// ===========================================================================================
// WARNING: using code other than public API or overwriting functions is extremely discouraged
// and may lead to instability or incompatibility with version upgrades!
// ===========================================================================================




var App = function() {
	
	///////////////////////////////
    /// SPA ///////////////////////
    ///////////////////////////////
	
	var previousHash = undefined;
	
	function _init() {
		Metadata.init(_getName());
	}
	
	function _isSPA() {
		return typeof app !== 'undefined' && app.isSPA === true;
	}
	
	function resetEvents() {
		Object.keys(Events).forEach(function(key) {
			if (Events[key] instanceof Function && Events.global.indexOf(key) === -1) {
				Events[key] = function() {};
			}
		});
	}
	
	function omitExternalScripts(htmlContents) {	// we must avoid loading scripts via content.html() to workaround https://bugs.chromium.org/p/chromium/issues/detail?id=602051
		var scripts = [];
		var regex = "<script .*?src=\"(.*?)\".*?</script>";
		
		var redirect = htmlContents.match(regex);
		while (redirect !== null) {
			scripts.push(redirect[1]);
			htmlContents = htmlContents.replace(redirect[0], "");
			redirect = htmlContents.match(regex);
		}
		return {htmlContents: htmlContents, scripts: scripts};
	}
	
	function omitRedirect(htmlContents) {
		var redirect = htmlContents.match("<script .*?id=\"fragment_redirect\".*?</script>");
		return redirect !== null ? htmlContents.replace(redirect[0], "") : htmlContents;
	}
	
	function injectHtml(htmlContents) {
		var content = $('#content');
		content.html(omitRedirect(htmlContents));
		content.enhanceWithin();
	}
	
	function initFileHandler() {
	    $("input[type=file]").click(function(){
	        $(this).val("");
	        document.getElementById(this.id + '_filename').innerHTML = '(No file)';
	    });

	    $("input[type=file]").change(function(){
	        this.setAttribute("uploaded", false);
	        this.removeAttribute("fileFromCamera");
	        document.getElementById(this.id + '_filename').innerHTML = this.files[0].name;
	        $(this).blur();
	    });
	}
	
	function animateInject() {
		var injectAnimation = $("#mainPage").attr("inject-animation");
		if (injectAnimation) {
			switch (injectAnimation) {
				case "fade":
					$("#content").animate({opacity: 1}, 500);
					break;
				case "slide-down":
					$("#content").css("opacity","1").hide().slideDown( 700 );	
					break;
				case "slide-side":
					$("#content").css("opacity","1").hide().show("slide", { direction: "left" }, 400);
					break;	
				default:
					$("#content").css("opacity","1");
			}
		} else {
			$("#content").css("opacity","1");
		}
	}
	
	function injectNext(scripts, htmlContents) {
		window[window.location.hash.substr(1).toLowerCase()+"Page"].call(window);
		window["handlerMap"] = window[window.location.hash.substr(1).toLowerCase() + "_handlerMap"];
		injectHtml(htmlContents);
		animateInject();
		$("#spinner").css("display","none");
		initFileHandler();
	}

	function injectContent(hash) {
		saveUserData();
		
		$('#content').html("");
		var manipulated = omitExternalScripts(appHtmls[hash.replace("#","").toLowerCase()]);
		var scripts = manipulated.scripts;
		injectNext(scripts, manipulated.htmlContents);
	}
	
	function loadSPAFragment(hash) {
		resetEvents();
		injectContent(hash);
	}
	
	function onhashchange(e) {
		var hash = Page.getFragment(location.hash);
		
		if (hash === '' && previousHash !== undefined) {
			console.warn('hashchange: tried to change to empty hash');
			window.location.hash = previousHash;		// empty hash protection: restore previous hash
			previousHash = hash;
			return;
		}
		if (previousHash === '') {
			previousHash = hash;
			return;		// hashchange was triggered by the empty hash protection in the previous 'if' block
		}
		
		if (hash !== previousHash && (isIE() || e.originalEvent.oldURL.indexOf("theme_editor") == -1)) {
			$("#content").css("opacity","0");
			$("#spinner").css("display","block");
			loadSPAFragment(hash);
			previousHash = hash;
		}
	}
	
	function _initSPA(pageNames) {
		_init();
		spa_entryFragment = pageNames[0];
		$(window).bind('hashchange', onhashchange);
		
		$(function() {
			if (document.URL.indexOf("theme_editor") == -1) {
				$("#content").css("opacity","0");
				$("#spinner").css("display","block");
				if (location.hash !== "") {
					loadSPAFragment(location.hash);
				} else {
					Page.navigate(spa_entryFragment);
				}
			}
		});
	}
	
	///////////////////////////////
    /// PWA ///////////////////////
    ///////////////////////////////
	
	var a2hsPrompt;
	var isNewVersion = false;
	
	function onServiceWorkerStatusChange() {
		if (navigator.serviceWorker.controller !== null && navigator.serviceWorker.controller.state === 'activated' && isNewVersion) {
    		window.location.reload();
    	}
	}
	
	function registerServiceWorker() {
		if ('serviceWorker' in navigator) {
			window.addEventListener('load', function() { 
				navigator.serviceWorker.register('sw.js').then(function(reg) {
					console.log('Service Worker: registered');
					
					reg.addEventListener('updatefound', function() {
				    	var newWorker = reg.installing;
					    newWorker.addEventListener('statechange', function(a) {
					    	// "installing" - the install event has fired, but not yet complete
					    	// "installed"  - install complete
					    	// "activating" - the activate event has fired, but not yet complete
					    	// "activated"  - fully active
					    	// "redundant"  - discarded. Either failed install, or it's been replaced by a newer version
					    	console.log('Service Worker: ' + newWorker.state);
					    	onServiceWorkerStatusChange();
					    });
					});
				}, function(e) {
					console.error('ServiceWorker registration failed: ', e.toString());
				});
			});
		}
	}
	
	function registerPWAEventListeners() {
		window.addEventListener('beforeinstallprompt', function(e) {
			e.preventDefault();		// Prevent the auto install prompt (Chrome 76 and later)
			a2hsPrompt = e;				// Stash the event so it can be triggered later.
			
			if (!window.APPWAdeferredPrompt && Device.isMobileOrTablet()) {
				if (window.APPWAPromptUserResponded)
					return;
	
				// Update UI notify the user they can install the PWA
				Popup.okCancel("Install Application", "Do you want to install " + _getName() + " on your device?", function() {
					a2hsPrompt.prompt();	// Show the install prompt
					a2hsPrompt.userChoice.then(function(choiceResult) {
						window.APPWAPromptUserResponded = true;
					});
				}, function() {
					window.APPWAPromptUserResponded = true;
				});
			}
		});

		window.addEventListener('appinstalled', function(e) {
			console.log('App successfully added to home screen.');
		});
		
		navigator.serviceWorker.onmessage = function (e) {
		    console.log('Received message from Service Worker: ' + e.data);
		    if (e.data === 'CACHE_EVICTED') {
		    	if (navigator.serviceWorker.controller.state === 'activated') {
		    		window.location.reload();
		    	} else {
		    		isNewVersion = true;
		    	}
		    }
		};
	}
	
	function _initPWA() {
		_init();
		if (document.URL.indexOf("theme_editor") == -1) {
			registerServiceWorker();
			registerPWAEventListeners();
		}
	}

	
	function _isOpenedViaHome() {
		return window.location.search.substring(1).split('=')[1] === 'homescreen';
	}
	
	function _add2Home() {
		if (!Device.isMobileOrTablet()) {
			Popup.ok('Add to Home Screen', 'Supported on mobile devices only!');
			return;
		}
		if (_isOpenedViaHome()) {
			Popup.ok('Add to Home Screen', 'Already added- app was launched via Home shortcut!');
			return;
		}
		if (typeof a2hsPrompt === "undefined") {
			Popup.ok('Add to Home Screen', 'Browser didn\'t offer install on Home! Please re-open the app and try again.');
			return;
		}
		if (a2hsPrompt == null) {
			Popup.ok('Add to Home Screen', 'Already added- prompt consumed by this instance!');
			return;
		}
		
		a2hsPrompt.prompt();
		a2hsPrompt.userChoice.then(function(choiceResult) {
			if (choiceResult.outcome === 'accepted') {
				console.log('User accepted the A2HS prompt');
				a2hsPrompt = null;
			}
		});
	}
	
	function _getName() {
		return window.location.href.match(/\/apps\/([a-zA-z0-9]*)\//)[1];
	}
	
	function _getVersion() {
		return document.querySelector("meta[name='version']").getAttribute("content");
	}
	



	///////////////////////////////
    /// API ///////////////////////
    ///////////////////////////////
	
	return {
		initSPA: 			_initSPA,
		initPWA:			_initPWA,
		init: 				_init,
		isSPA:				_isSPA,
		isOpenedViaHome:	_isOpenedViaHome,
		add2Home:			_add2Home,
		
		getName:			_getName,
		getVersion:			_getVersion
	};
}();

/****** barcode.js ******/
function initBarcodeListener(_onReadCallback, _ignoredChars, _minLength, _maxInputInterval) {
	Barcode.init(_onReadCallback, _ignoredChars, _minLength, _maxInputInterval);
}

/****** gps.js ******/
function getLocation(callback) {
	Location.getCurrentPosition(callback);
}
function populatePosition(callback, position) {
	Location.resolveAddress(callback, position);
}

/****** handlers.js ******/
function callWebService(webService, params, initHandler, responseHandler, failureHandler, asyncFlag, populateFields, context) {
	Services.callWebService(webService, params, initHandler, responseHandler, failureHandler, asyncFlag, populateFields, context);
}
function callWebServiceWithAllParams(webService, initHandler, responseHandler, failureHandler, asyncFlag, populateFields) {
	Services.callWebServiceWithAllParams(webService, initHandler, responseHandler, failureHandler, asyncFlag, populateFields);
}
function navigate(targetUrl) {
	Page.navigate(targetUrl);
}
function showServiceErrorsPopup(serviceErrorMsg, status) {
	Popup.serviceErrors(serviceErrorMsg, status);
}

/****** init.js ******/
function initData() {
	Init.initData();
}

/****** lov.js ******/
function setAutocomplete(elementId, serviceName, labelItemPairs, keepClosed) {
	Lov.setAutocomplete(elementId, serviceName, labelItemPairs, keepClosed);
}
function getSuggestions(elementId, serviceName) {
	Lov.getSuggestions(elementId, serviceName);
}
function prepareLOV(elementId, serviceName) {
	Lov.initDynamic(elementId, serviceName);
}
function prepareMobileLOV(options) {
	Lov.initDynamic(options.elementId, options.webService);
}
function prepareStaticLOV(elementId, _lov_labelItemPairs, isTableHeader) {
	Lov.initStatic(elementId, _lov_labelItemPairs, isTableHeader);
	
}

/****** map.js ******/
function generateAddress() {
	return Location.buildAddress();
}
function geocodeAddress(address, isButtonTriggered) {
	Location.markOnMap(address, isButtonTriggered);
}

/****** spinner.js ******/
function spinner() {
	return {
    	start: Spinner.start,
        stop: Spinner.stop
    };
}
function startSmallSpinner(text) {
	Spinner.startMiniSpinner(text);
}
function stopSmallSpinner() {
	Spinner.stopMiniSpinner();
}

/****** table.js | tableTableLayout.js | tableListLayout.js ******/
function clearAllTableRows() {
	Table.clear();
}
function clearAllTableListLayoutRows() {
	List.clear();
}

/****** partial.js ******/
function startSession() {
	Services.startSession();
}
function endSession() {
	Services.endSession();
}
function killSession(_sessionId) {
	Services.killSession(_sessionId);
}

/****** popup.js ******/
function showInfoPopup(title, message, okCallback) {
	Popup.info(title, message, okCallback);
}
function showConfirmPopup(title, message, okCallback, cancelCallback) {
	Popup.confirm(title, message, okCallback, cancelCallback);
}

/****** fields.js *****/
function getResponseNodeListValueByName(nodeName) {		// some clients might use it
    if (window.response == null)
        return "";
    return findValues(window.response, nodeName);
}
function getFieldValue(key) {
	return Fields.get(key) || '';
}
function populateField(fieldName, fieldValue) {
	Fields.setAndStore(fieldName, fieldValue);
}

function populateFieldHTML(fieldName, fieldValue) {
	Fields.set(fieldName, fieldValue);
}

function setDefaultValues() {
	Fields.setDefaultValues();
}
function setUserDataValuesInFields() {
	Fields.setFromStorage();
}
function validateRequiredFields() {
	Fields.validate();
}
function getURLParameters(url) {
	return Page.parseQueryParams();
}
function refreshInputElements() {}		// backward compatibility, old pages might call this on init
function removeDuplicatedFields() {}	// backward compatibility, old pages might call this on init


/****** storage.js ******/
function clearUserData() {
	Storage.clear();
}
function clearStorageByPrefix(prefix) {
	Storage.clearByPrefix(prefix);
}
function clearAllStorageIndices(paramName) {
	Storage.clearAllIndices(paramName);
}
function containsKey(key) {
	return Storage.contains(key);
}
function backupField(fieldName) {
	Storage.backup(fieldName);
}
function storeFromIndex(fieldName, index, shouldBackup) {
	if (shouldBackup === true) {
		Storage.backupAndCopyFromIndex(fieldName, index);
	} else {
		Storage.copyFromIndex(fieldName, index);	
	}
}
function store(fieldName, fieldValue, shouldBackup) {
	if (shouldBackup === true) {
		Storage.backupAndSet(fieldName, fieldValue);
	} else {
		Storage.set(fieldName, fieldValue);
	}
}
function restoreBackedupIndices() {
	Storage.restoreBackups();
}
function storeArrayInSessionStorage(array) {	// backward compatibility, old pages might call it
	populateArray(array);
}
function removeItem(key) {
	Storage.remove(key);
}
function removeItemNameContains(substr) {
	Storage.removeBySubstring(substr);
}
function saveUserData() {
	Fields.storeAll();
}
function getSessionFieldValue(key, shouldTrimValue) {
    return Storage.get(key);	// will always clean value
}

/****** offline.js ******/
function checkOfflineSupport() {
	if (!Offline.isSupported()) {
		showInfoPopup('Offline Support', 'LocalStorage is not supported by your browser, offline capabilities malfunction.');
	}
}
function storeOfflineResponseIfNeeded(serviceName, response) {
	Offline.storeResponse(serviceName, response);
}
function loadCachedOfflineResponse(serviceName) {
	return Offline.loadResponse(serviceName);
}
function deleteOfflineResponse(serviceName) {
	Offline.deleteResponse(serviceName);
}
function deleteAllOfflineResponses() {
	Offline.deleteAllResponses();
}

var Barcode = function() {
		
	return {
		init: function(callback, filter, minLength, maxInterval) {
			$('#header').append('<div id="barcodeToast"><div id="barcodeValue"></div></div>');
		    
		    var _timeoutHandler = 0;
		    var _inputString = '';
		    
		    $(document).on({
		        keypress: function(e) {
		            if (_timeoutHandler > 0) {
		                clearTimeout(_timeoutHandler);
		            }
		            _inputString += e.key;
		            
		            var maxInputInterval = (maxInterval !== undefined ? maxInterval : 50);
		            
		            _timeoutHandler = setTimeout(function () {
		            	// min length threshold
		            	var minLength = (minLength !== undefined ? minLength : 6);
		                if (_inputString.length < minLength) {
		                    _inputString = '';
		                    return;
		                }
		                
		                // filter chars and toast
		                if (filter !== undefined) {
		                	_inputString = _inputString.replace(new RegExp('[' + filter + ']', 'g'), '');
		                }
		                $('#barcodeValue').text('Barcode: ' + _inputString);
		                
		                // callback
		                var onReadCallback = (typeof callback === 'string' ? window[callback] : typeof callback === 'function' ? callback : undefined);
		                if (onReadCallback !== undefined) {
		                	onReadCallback(_inputString);
		                }
		                
		                _inputString = '';
		                
		            }, maxInputInterval);
		        }
		    });
		}
	};
}();

var Converters = {

};

/*\
 |*|  :: cookies.js ::
 |*|  A complete cookies reader/writer framework with full unicode support.
 |*|  https://developer.mozilla.org/en-US/docs/DOM/document.cookie
 |*|
 |*|  This framework is released under the GNU Public License, version 3 or later.
 |*|  http://www.gnu.org/licenses/gpl-3.0-standalone.html
 |*|
 |*|  Syntaxes:
 |*|  * docCookies.setItem(name, value[, end[, path[, domain[, secure]]]])
 |*|  * docCookies.getItem(name)
 |*|  * docCookies.removeItem(name[, path], domain)
 |*|  * docCookies.hasItem(name)
 |*|  * docCookies.keys()
 \*/

var docCookies = {
    getItem: function (sKey) {
        return decodeURIComponent(document.cookie.replace(new RegExp("(?:(?:^|.*;)\\s*" + encodeURIComponent(sKey).replace(/[\-\.\+\*]/g, "\\$&") + "\\s*\\=\\s*([^;]*).*$)|^.*$"), "$1")) || null;
    },
    setItem: function (sKey, sValue, vEnd, sPath, sDomain, bSecure) {
        if (!sKey || /^(?:expires|max\-age|path|domain|secure)$/i.test(sKey)) {
            return false;
        }
        var sExpires = "";
        if (vEnd) {
            switch (vEnd.constructor) {
                case Number:
                    sExpires = vEnd === Infinity ? "; expires=Fri, 31 Dec 9999 23:59:59 GMT" : "; max-age=" + vEnd;
                    break;
                case String:
                    sExpires = "; expires=" + vEnd;
                    break;
                case Date:
                    sExpires = "; expires=" + vEnd.toUTCString();
                    break;
            }
        }
        document.cookie = encodeURIComponent(sKey) + "=" + encodeURIComponent(sValue) + sExpires + (sDomain ? "; domain=" + sDomain : "") + (sPath ? "; path=" + sPath : "") + (bSecure ? "; secure" : "");
        return true;
    },
    removeItem: function (sKey, sPath, sDomain) {
        if (!sKey || !this.hasItem(sKey)) {
            return false;
        }
        document.cookie = encodeURIComponent(sKey) + "=; expires=Thu, 01 Jan 1970 00:00:00 GMT" + ( sDomain ? "; domain=" + sDomain : "") + ( sPath ? "; path=" + sPath : "");
        return true;
    },
    hasItem: function (sKey) {
        return (new RegExp("(?:^|;\\s*)" + encodeURIComponent(sKey).replace(/[\-\.\+\*]/g, "\\$&") + "\\s*\\=")).test(document.cookie);
    },
    keys: /* optional method: you can safely remove it! */ function () {
        var aKeys = document.cookie.replace(/((?:^|\s*;)[^\=]+)(?=;|$)|^\s*|\s*(?:\=[^;]*)?(?:\1|$)/g, "").split(/\s*(?:\=[^;]*)?;\s*/);
        for (var nIdx = 0; nIdx < aKeys.length; nIdx++) {
            aKeys[nIdx] = decodeURIComponent(aKeys[nIdx]);
        }
        return aKeys;
    }
};

var Debugger = function() {
	
	var origOpen = XMLHttpRequest.prototype.open;
	var origSend = XMLHttpRequest.prototype.send;
	var origExecuteHandler = executeHandler;
	var logExpanded = false;
	var filteredRequestTypes = [".html", ".js"];
	
	function _clearLog() {
		$(".log-row").remove();
		for (var i = sessionStorage.length - 1; i >= 0; i--){
			if (sessionStorage.key(i).indexOf("req:") != -1) {
				sessionStorage.removeItem(sessionStorage.key(i));
			}
		}
	}
	
	function _closeLog() {
		$('#debugger-log').remove();
	}
	
	function getTimeFromTimestamp(unix_timestamp) {
		var date = new Date(unix_timestamp );
		var hours = date.getHours();
		var minutes = "0" + date.getMinutes();
		var seconds = "0" + date.getSeconds();
		var milli = "0" + date.getMilliseconds();
		var formattedTime = hours + ':' + minutes.substr(-2) + ':' + seconds.substr(-2) + ":" + milli.substr(-2);
		return formattedTime;
	}
	
	function _showLog() {
	    $('#debugger-log').remove();
		$("body").prepend($('<div id="debugger-log">' +
								'<div class="debug-actions">' +
									'<button id="debug-clear"> Clear log </button> ' + 
									'<button id="debug-copy" > Copy </button> ' +
									'<button id="debug-save" > Save </button> ' +
									'<button id="debug-collapse-expand"> Expand All </button> ' +
									'<button id="close-log"> X </button>' +
								'</div>' +
							'</div>'));
		$("#debug-clear").click(function() {
			 Debugger.clearLog();
		});
		$("#debug-copy").click(function() {
			Debugger.copyLog();
		});
		$("#debug-save").click(function() {
			Debugger.saveLog();
		});
		$("#debug-collapse-expand").click(function() {
			Debugger.expandCollapseLog();
		});
		$("#close-log").click(function() {
			Debugger.closeLog();
		});
		var resultArray = [];
		for (var i = 0; i < sessionStorage.length; i++){
			if (sessionStorage.key(i).indexOf("req:") != -1) {
				resultArray.push({
					date: Number(sessionStorage.key(i).substring( sessionStorage.key(i).indexOf(":") + 1,  sessionStorage.key(i).lastIndexOf(";"))),
					title: sessionStorage.key(i).substring( sessionStorage.key(i).indexOf(";") + 1) ,
					key: sessionStorage.key(i),
					data: sessionStorage.getItem(sessionStorage.key(i))
				  });
			}
		}
		
		resultArray = resultArray.sort(function(a,b){
			return new Date(b.date) - new Date(a.date);
		});
		 
		for (var i = 0; i < resultArray.length; i++){
			var row = $("<div class='log-row'> <span class='row-key'><span class='log-time'></span> <span class='log-title'> </span></span> <div class='row-data'> </div> </div>");
			$('#debugger-log').append(row);
			$(row).find(".log-time").html(getTimeFromTimestamp(resultArray[i].date));
			$(row).find(".log-title").html(resultArray[i].title);
			$(row).find(".row-data").html(resultArray[i].data);
		}
		
		$(".row-key").click(function() {
			$(this).next(".row-data").toggle();
			$(this).toggleClass( "open" )
		});
	}
	
	function _expandCollapseLog() {
		if (logExpanded) {
			logExpanded = false;
			$(".row-key").each(function() {
				$(this).next(".row-data").hide();
				$(this).removeClass("open");
				$("#debug-collapse-expand").html("Expand All"); 
			});
		} 
		else {
			logExpanded = true;
			$(".row-key").each(function() {
				$(this).next(".row-data").show();
				$(this).addClass("open");
				$("#debug-collapse-expand").html("Collapse All"); 
			});
		}
	}
	
	function _startDebugging() {
		sessionStorage.setItem("debugger", "true");
		if ($("debugger").length == 0) {
			$("#leftpanel .ui-panel-inner").append('<div id="debugger"> <div style="overflow:auto"><button id="show-log-btn"> show log </button><button id="stop-debugging-btn">  stop debugging </button></div>' +
						'<div style="margin-top:10px;"> <span style="position:relative;top:5px;"> capture snapshots</span> <select id="screenshots" style="float:right;" name="screenshots"data-role="flipswitch"> <option value="false">off</option>'+
		    	       '<option value="true">on</option> </select> </div> </div>');
		}
		$("#show-log-btn").click(function() {
			Debugger.showLog();
		});
	
		$("#screenshots").flipswitch();
		$("#screenshots").on("change", function() {
			sessionStorage.setItem("screenshots", this.value );
		});
		if (sessionStorage.getItem("screenshots") && 
				sessionStorage.getItem("screenshots") == "true") {
			$('#screenshots').val("true");
		} else {
			$('#screenshots').val("false");
		}
	
		
		$("#stop-debugging-btn").click(function() {
			Debugger.stop();
		});
		$("#debugger").show();
		recordRequests();
		recordExecuteHandlers();

		Events.debuggerInit();
	}
	
	function _stopDebugging() {
		sessionStorage.setItem("screenshots", "false" );
		sessionStorage.setItem("debugger", "false");
		_clearLog();
		$("#debugger").hide();
		$("#debugger").remove();
		$('#debugger-log').remove();
		stopRecordingRequests();
		stopRecordExecuteHandlers();
	}
	
	function stopRecordingRequests() {
		XMLHttpRequest.prototype.send = origSend;
		XMLHttpRequest.prototype.open = origOpen;
	}
	
	function stopRecordExecuteHandlers() {
		executeHandler = origExecuteHandler;
	}
	
	function recordExecuteHandlers() {
		executeHandler = function(handler) {
			var time = Date.now();
			var handlerNameType = "";
			var action = handler.action;
			
			if (handler.action.indexOf(":") != -1) {
				 action = handler.action.substring(0, handler.action.indexOf(":") )
			}
			
			switch (action) {
				case "webservice": 
				case "navigate": 
				case "function":
					if (handler.key) {
						handlerNameType = "Key Click";
					} else {
						handlerNameType = "Button Click";
					}	
					break;
			
				case "tableClick":
					handlerNameType = "Table Click";		
					break;
				case "onload":
					handlerNameType = "Page Load";		
					break;	
				default:
					handlerNameType = handler.action;
					break;
			}
			
			var handleTitle = handler.element? handler.element: handler.elementId? handler.elementId : handler.key? String.fromCharCode(handler.key): false;
			

		    currReq = "req:" + time + ";" + handlerNameType + (handleTitle? " - "+ handleTitle: "")  ;
			recordAction.call({currReq: currReq }, "<span class='row-key'> Action Handler  </span>" + "<span class='row-data'> " + JSON.stringify(handler) + "</span>");
			origExecuteHandler.apply(this, arguments);
		}
	}
	
	function recordAction(action) {
		if (this.currReqIsFiltered) return;
		console.log(action);
		sessionStorage.setItem(this.currReq,  (sessionStorage.getItem(this.currReq)? sessionStorage.getItem(this.currReq): '') + "<div style='margin-bottom:3px;'>" + action + "</div>" );
	}
	
	function _copyLog() {
		CopyToClipboard("debugger-log");
		alert("Copied to clipboard");
	}
	
	function getHTMLStringForElementId(containerid) {
		return "<html><head><style>.debug-actions {display:none}.log-row{ border: 1px solid black; margin-bottom: 10px; }</style></head><body>" 
		+ $("#"+ containerid).html()  + "</body></html>";
	}
	
	function CopyToClipboard(containerid) {
		var tmpElem = $('<div id="tmp-duplicate">');
	    tmpElem.css({
	    	position: "absolute",
	    	left:     "-1000px",
	    	top:      "-1000px",
	    });
	    tmpElem.text(getHTMLStringForElementId(containerid));
	    $("body").append(tmpElem);
	    if (document.selection) {
	    var range = document.body.createTextRange();
	    range.moveToElementText(document.getElementById("tmp-duplicate"));
	    range.select().createTextRange();
	    try { 
	    	 document.execCommand("copy");
	    } catch (err) {
	        alert("failed to copy");
	    }
	   
	  } else if (window.getSelection) {
		  var range = document.createRange();
		  range.selectNode(document.getElementById("tmp-duplicate"));
		  window.getSelection().removeAllRanges();
		  window.getSelection().addRange(range);
		  try { 
			  document.execCommand("copy");
		  } catch (err) {
			  alert("failed to copy");
		  }
	  }
	  $("#tmp-duplicate").remove();
	}
	
	function _saveLog() {
		var formattedBody =  getHTMLStringForElementId("debugger-log");
		
		Files.uploadString(formattedBody, '<timestamp>.html').then(function(response) {
			alert("Saved on server to: " + response.data);
		});
	}
	
	
	function _sendLog() {	
		var formattedBody = $("#debugger-log").text();
		var mailToLink = "mailto:support@auraplayer.com?subject=Auraplayer Debug Log&body=" + encodeURIComponent(formattedBody);
		try {
			window.location.href = mailToLink;
		} catch (e) {
			alert('error sending mail');
		}
	}
	
	function _isFilteredRequest(requestArguments) {
		for (var i=0;i<filteredRequestTypes.length; i++) {
			if (requestArguments[1].indexOf(filteredRequestTypes[i]) != -1) {
				return true;
			}
		}
		return false;
	}
	
	function XMLHttpRequest_onSend(params) {
		var paramsString = decodeURIComponent(params);
		try {
			var paramKeyValues = paramsString.replace(/^\?/, '').split('&');
			var paramCouples = "";
			
			for(i=0; i<paramKeyValues.length; i++) {
				if (paramKeyValues[i].indexOf("=") != -1) {
					var keyValueSplit = paramKeyValues[i].split('=');
					paramCouples +=  keyValueSplit[0]  + " : " +  keyValueSplit[1];
				} else {
					paramCouples += paramKeyValues[i];
				}
				paramCouples += "\n";
			}
			paramsString = paramCouples;
		} catch (e) {
			paramsString = decodeURIComponent(params);
		}
		this.recordAction("<span class='row-key'  style='font-weight:bold'> Data  </span>" + "<div class='row-data'>" + (paramsString !== undefined? paramsString : '') + "</div>");
		this.recordAction("<span style='color:blue;'> Request Sent  </span>");
		return origSend.call(this, params);
	}
	
	function XMLHttpRequest_onLoadListener() {
		this.recordAction("<span style='color:blue;'> Request Completed </span>");
    	var response = this.responseText;
    	 try {
 	       response = JSON.stringify(JSON.parse(this.responseText), undefined, 2);
 	    } catch (e) {
 	       response = this.responseText;
 	    }
 	    
    	this.recordAction("<span class='row-key'  style='font-weight:bold'> Response </span>" + "<div class='row-data'> " + $('<div/>').text(response).html() + "</div>");
	}
	
	function XMLHttpRequest_onOpen() {
    	var time = Date.now();
    	currReq = "req:" + time + ";" + (arguments !== undefined && arguments[1] !== undefined?  arguments[1] :'');
    	this.currReq = currReq;
    	this.currReqIsFiltered = Debugger.isFilteredRequest(arguments);
    	this.recordAction = recordAction;
    	
    	this.recordAction("<span style='text-decoration:underline;'> Request Started </span>");
    	this.recordAction("<span class='row-key'  style='font-weight:bold'> Arguments </span>" + "<span class='row-data'> " + JSON.stringify(arguments) + "</span>");
        this.addEventListener("readystatechange", function () {
          	switch (this.readyState) {
          		case 1:
          			this.recordAction("<span style='font-weight:bold'> Ready State </span>:  <span style='color:orange;'> OPENED </span> ");
          			break;
          		case 2:     			 
          			this.recordAction("<span style='font-weight:bold'> Ready State </span>:  <span style='color:orange;'> HEADERS_RECEIVED </span> ");
          			break;
          		case 3:
          			this.recordAction("<span style='font-weight:bold'> Ready State </span>:  <span style='color:orange;'> LOADING </span> ");
          			break;
          		case 4:
          			this.recordAction("<span style='font-weight:bold'> Ready State </span>:  <span style='color:green;'> DONE </span> ")
          			this.recordAction("<span style='font-weight:bold'> Status </span>:  <span style='color:" + (this.status == "200"? "green": "red") + "'> "+ this.status +" </span> ")
          			break;
      		}
        });
        
        this.addEventListener('load', XMLHttpRequest_onLoadListener);
        return origOpen.apply(this, arguments);
    }
	
	function recordRequests() {
		XMLHttpRequest.prototype.send = XMLHttpRequest_onSend;
	    XMLHttpRequest.prototype.open = XMLHttpRequest_onOpen;
	};
	
	function initDebuggerListener(element) {
		TOUCH_TIMEOUT_MILLISECONDS = 500
		touch_count = 0
		
		window.onload = function () {
			element.addEventListener('touchend', function (evt) {
		        touch_count += 1
	
		        setTimeout(function () {
		            touch_count = 0
		        }, TOUCH_TIMEOUT_MILLISECONDS);
	
		        if (touch_count === 3) {
		        	_startDebugging();
		        }
		    });
		}
		
		element.addEventListener('click', function (evt) {
		    if (evt.detail === 3) {
		    	_startDebugging();
		    }
		});
		var timer,          // timer required to reset
	    timeout = 200;  // timer reset in ms
		
		element.addEventListener("dblclick", function (evt) {
		    timer = setTimeout(function () {
		        timer = null;
		    }, timeout);
		});
		
		element.addEventListener("click", function (evt) {
		    if (timer) {
		        clearTimeout(timer);
		        timer = null;
		        _startDebugging();
		    }
		});
	}
	
	$(document).ready(function (){
		if (sessionStorage.getItem("debugger") == "true") {
			_startDebugging();
		}
		if (document.querySelector('#leftpanel')) {
			initDebuggerListener(document.querySelector('#leftpanel'));
		}
	});
	
	return {
		showLog:				_showLog,
		start: 					_startDebugging,
		stop: 					_stopDebugging,
		clearLog: 				_clearLog,
		copyLog: 				_copyLog,
		saveLog:				_saveLog,
		closeLog: 				_closeLog,
		sendLog: 				_sendLog,
		expandCollapseLog:      _expandCollapseLog,
		isFilteredRequest :		_isFilteredRequest
	}
}();

var Device = function() {
	
	function _isMobile() {
		var result = false;
		(function(a){if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(a)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0,4))) result = true;})(navigator.userAgent||navigator.vendor||window.opera);
		return result;
	}
	
	function _isMobileOrTablet() {
		var result = false;
		(function(a){if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino|android|ipad|playbook|silk/i.test(a)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0,4))) result = true;})(navigator.userAgent||navigator.vendor||window.opera);
		return result;
	};
	
	function bytesToMBs(bytes) {
		return +((+bytes / (1024*1024)).toFixed(2));
	}
	
	function _getFreeSpace() {
		navigator.storage.estimate().then(function(info) {
			var quota = +((+info.quota / (1024*1024)).toFixed(2));
			var usage = +((+info.usage / (1024*1024)).toFixed(2));
			var free = +((quota - usage).toFixed(2));
			Popup.ok('Space usage', 'Total quota: ' + quota + ' MB.<br/>' + 'Free space: ' + free + ' MB.');
		});
	}
	
	return {
		getFreeSpace:		_getFreeSpace,
		isMobile:			_isMobile,
		isMobileOrTablet:	_isMobileOrTablet
	};
}();

var Events = {
	/** global events that shouldn't be reset when the page changes */
	global: 		['pageChanged', 'debuggerInit'],
		
	pageChanged: 	function() {},
		
	tableConfigure: function() {},
	tablePopulated: function() {},

	debuggerInit:	function(){}
};

var FieldDate = function() {
	
	///////////////////////////////////
    /// Formats ///////////////////////
    ///////////////////////////////////
	
	var DATE_SEPERATOR = "@";
	var DATE_FORMAT_TO_MOMENT_FORMAT = {
		"dd-mm-yy": "DD-MM-YYYY", 
		"dd-mm-y": "DD-MM-YY",
		"dd/mm/yy": "DD/MM/YYYY",
		"mm/dd/yy": "MM/DD/YYYY",
		"yy-mm-dd": "YYYY-MM-DD",
		"dd M, y": "DD MMM, YY",
		"dd-M-y": "DD-MMM-YY",
		"dd-M-yy": "DD-MMM-YYYY"
	};
	var DATE_FORMAT_TO_ANY_PICKER_FORMAT = {
		"dd-mm-yy": "dd-MM-yyyy", 
		"dd-mm-y": "dd-MM-yy",
		"dd/mm/yy": "dd/MM/yyyy",
		"mm/dd/yy": "MM/dd/yyyy",
		"yy-mm-dd": "yyyy-MM-dd",
		"dd M, y": "dd MMM, yy",
		"dd-M-y": "dd-MMM-yy",
		"dd-M-yy": "dd-MMM-yyyy"
	};
	
	function _getAnyPickerDisplayFormat (selectedDateSubType, selectedDateFormat) {
		var uiDateFormat = _getAnyPickerReturnDateFormat(selectedDateFormat);
		if (selectedDateSubType.toLowerCase() === "datetime" || (selectedDateSubType.toLowerCase() === "date")) {
			var uiDateFormat = _getAnyPickerReturnDateFormat(selectedDateFormat);
			if (uiDateFormat.indexOf('yyyy') == -1 ) {
				uiDateFormat = uiDateFormat.replace ('yy', 'yyyy');
			}
		}
		return uiDateFormat;
	}
	
	function _getAnyPickerReturnDateFormat (selectedDateFormat) {
		var dateFormat = selectedDateFormat;
		var dateOnlyFormat = selectedDateFormat.split(DATE_SEPERATOR)[0];
		if ( DATE_FORMAT_TO_ANY_PICKER_FORMAT[dateOnlyFormat] !== undefined) {
			dateFormat = selectedDateFormat.replace(dateOnlyFormat, DATE_FORMAT_TO_ANY_PICKER_FORMAT[dateOnlyFormat]);
		}
		return dateFormat.replace(DATE_SEPERATOR, " ");
	}
	
	///////////////////////////////////
    /// Init //////////////////////////
    ///////////////////////////////////
	
	function _initAnyPicker(date, elementId) {
		var ok, cancel;
		if ($("input[data-type='DATE']#" + elementId).attr("date-direction") == "rtl") {
			ok = "אישור";
			cancel = "ביטול"
		} else {
			ok = "OK";
			cancel = "Cancel"
		}
        
		var selectedDateFormat = $("input[data-type='DATE']#" + elementId).attr("date-format");          
		var selectedDateSubType = $("input[data-type='DATE']#" + elementId).attr("data-sub-type");     

		var uiDateFormat = _getAnyPickerDisplayFormat(selectedDateSubType, selectedDateFormat);
		var returnDateFormat = _getAnyPickerReturnDateFormat(selectedDateFormat);
           
       	$("input[data-type='DATE']#" + elementId).removeAttr('type').attr('readonly','true');
       	$("input[data-type='DATE']#" + elementId).AnyPicker("destroy");
		$("input[data-type='DATE']#" + elementId).AnyPicker({
			onInit: function() {
                this.setSelectedDate(date);
            },
            onSetOutput: function(sOutput, oSelectedValues) {
				if (!oSelectedValues.values[1] || !oSelectedValues.values[1].label) {
					this.setSelectedDate( new Date(2015, 9, 20, oSelectedValues.values[0].label, 0, 0, 0));
				}
            },
            headerTitle: {
				type: "Text",
				markup: "<div class='ap-ex-contentTop'></div>"
			},
            cancelButton: {
				type: "Button",
				markup: "<span class='my-cancel' > ביטול</span>"
			},
            setButton: {
				type: "Button",
				markup: "<span class='my-confirm' > אישור</span>"
			},
            viewSections: {
				header: ["headerTitle"],
				contentTop: [],
				contentBottom: [],
				footer: ["cancelButton", "setButton"]
			},
            mode: "datetime",
            intervals: {
                h: 1,
                m: 1,
            },
            i18n: {
				setButton: ok,
				cancelButton: cancel
			},
            dateTimeFormat: uiDateFormat,
            inputDateTimeFormat: returnDateFormat
        });
    }
	
	///////////////////////////////////
    /// Set ///////////////////////////
    ///////////////////////////////////
	
	function _populateDateField(fieldElement, fieldValue) {
		if (fieldValue == null || fieldValue == undefined || (typeof fieldValue === 'string' && fieldValue == '')) {
			fieldElement.value = null;
			return;
		}

		var dateSubType = fieldElement.getAttribute("data-sub-type");
		var date = new Date();
		if ( typeof fieldValue === 'string' ) {
			var dateFormat = fieldElement.getAttribute("date-format").split(DATE_SEPERATOR);
			var momentDate;
			if (dateSubType.toLowerCase() === "date") {
				momentDate = moment(fieldValue, DATE_FORMAT_TO_MOMENT_FORMAT[dateFormat[0]]);
			} else if (dateSubType.toLowerCase() === "time") {
				momentDate = moment(fieldValue, dateFormat[0]);
			} else if (dateSubType.toLowerCase() === "datetime"){
				momentDate = moment(fieldValue, DATE_FORMAT_TO_MOMENT_FORMAT[dateFormat[0]] + " " + dateFormat[1]);
			} else {
				console.error ("Invalid Date subtype: dateSubType");
			}
			if (momentDate.isValid()) {
				date = new Date(momentDate);
			} else {
				date = null;
				fieldElement.value = null;
			}
		} else if (fieldValue !== 0) {
			//Default value is saved as timestamp, 0 means current value	    					
			date = new Date(fieldValue);
		} 
		_initAnyPicker(date, fieldElement.id);
	}
	
	function _initDate(paramName, format) {
        var element = $('#' + paramName);
        $(element).attr("date-format",format);
        $(element).attr("placeholder",format.replace("@", " "));
        _initAnyPicker(null, paramName);
	}
	
	///////////////////////////////////
    /// API ///////////////////////////
    ///////////////////////////////////
	
	return {
		initDate:				_initDate,
		populateDateField:		_populateDateField
	};
}();
var Fields = function() {
	
	var excludedKeys = ["debugger", "_metadata", "req:"]
	
	///////////////////////////////////
    /// Clear /////////////////////////
    ///////////////////////////////////
	
	
	function clearLOV(fieldName) {
		setCommonField(fieldName, "");
		$("#"+fieldName).parent().autocomplete.term = null; 
		$("#"+fieldName).attr("value", "" );
	}
	
	function _clearAll() {
		$("input").val("");
		$(".output_value").val("");
		$(".output_value").text("");
		
		$(".dropdown-container").each(function(key, value){
			var id = $(this).find(">:first-child").attr("id");
			clearLOV(id);
		});
	    var table = document.getElementById('tableOutput');		// clear output table
	    if (table != null) {
	        for (var i = table.rows.length - 1; i > 0; i--) {
	            table.deleteRow(i);
	        }
	    }
	    
	}
	
	function _clear(fieldName) {
		if (fieldName === undefined) {
			Fields.clearAll();
			return;
		}
		if ($("#"+fieldName).parent().hasClass("dropdown-container")) {
			 clearLOV(fieldName);
		} else {
			var element = $("#" + fieldName);
			element.val("");
			element.text("");
		}
	
	}
	
	function _clearByPrefix(prefix) {
		$("input[id^='" + prefix + "']").val("");
	}
	
	///////////////////////////////////
    /// Set ///////////////////////////
    ///////////////////////////////////
	
	function omitLineBreaks(expression) {
		return isString(expression) ? expression.replace(/\n/g, ' ') : expression;
	}
	
	function _applyConverter(fieldId, fieldValue) {
		var converter = 'format_' + fieldId;
		var backwardCompatibilityConverter = window['convert_' + fieldId];
		
		return 	Converters.hasOwnProperty(converter) && isFunction(Converters[converter]) ? Converters[converter](fieldValue) :
				typeof backwardCompatibilityConverter === "function" ? backwardCompatibilityConverter(fieldValue) :
				fieldValue;
	}
	
	function _populateCheckboxHTML(fieldElement, fieldValue) {
		fieldValue = (typeof fieldValue === "boolean" ? fieldValue : "" + _applyConverter(fieldElement.id, fieldValue) === "true");
		$(fieldElement).checkboxradio({});
		$(fieldElement).prop('checked', fieldValue).checkboxradio("refresh");
		
	}
	
	function _populateFieldCommon(fieldElement, fieldValue) {
		try {
			var isMobile = /iPhone|iPad|iPod|Android/i.test(navigator.userAgent);
	        var nodeName = fieldElement.nodeName;
			if (fieldElement.id === 'map') {
				document.getElementById('map_address').innerHTML = fieldValue;
				Location.markOnMap(fieldValue);
			} else if (nodeName === "INPUT") {
	    		if (fieldElement.type === "checkbox") {
	    			_populateCheckboxHTML(fieldElement, fieldValue);
	    		} else if (fieldElement.getAttribute('data-type') === 'DATE') {
	    			FieldDate.populateDateField(fieldElement, fieldValue);
	    		} else {
	    			fieldElement.value = omitLineBreaks(_applyConverter(fieldElement.id, fieldValue));
	    			if (fieldElement.type === "text") {
	    				FieldText.populateTextField(fieldElement, fieldValue);
	    			}
	    		}
	    	} else if (nodeName === "TEXTAREA") {
	            fieldElement.value = fieldValue;
	        } else if (nodeName === "DIV" || nodeName === "LABEL") {
	            fieldElement.innerHTML = omitLineBreaks(fieldValue) || "";
	        } else if (nodeName === "SELECT") {		// slider
	        	$(fieldElement).val(fieldValue).flipswitch('refresh');
	        } else if (nodeName === "IMG") {
	        	fieldElement.src = _applyConverter(fieldElement.id, fieldValue);
	        } else if (nodeName === "A") {
	        	if (fieldElement.href.indexOf("tel:") === 0) {
	        		fieldElement.innerHTML = fieldValue || "";
	        		fieldElement.href = "tel:" + fieldValue;
	        	} 
	        }
	    } catch (e) {}
	}
	
	
	function setCommonField(fieldName, fieldValue) {
		 var fieldElement = document.getElementById(fieldName);
		    if (fieldElement !== null && typeof(fieldValue) !== "undefined") {
		    	_populateFieldCommon(fieldElement, fieldValue);
		  }
	}
	
	function _set(fieldName, fieldValue) {
		if ($("#"+fieldName).parent().hasClass("ui-autocomplete-input")) {
			var source = $("#"+fieldName).parent().autocomplete( "option", "source" );
			var valueFound = false;
			for (var i=0; i<source.length; i++) {
				if (source[i].item == fieldValue || source[i].label == fieldValue ) {
					valueFound = true;
					setCommonField(fieldName, source[i].label)
					if (source[i].item) {
						if (typeof source[i].item === 'object') {
							$("#"+fieldName).attr("value",source[i].item[Object.keys(source[i].item)[0]]);
						} else {
							$("#"+fieldName).attr("value",source[i].item );
						}
					}
				}
			}
			if (!valueFound && !fieldValue) {
				 clearLOV(fieldName);
			}
			
		} else {
			 setCommonField(fieldName, fieldValue);
		}
	}
	
	function _setAndStore(fieldName, value) {
		Fields.set(fieldName, value);
	    try {
	        sessionStorage.setItem(fieldName, typeof value === "object"? JSON.stringify(value): value);
	    } catch (e) {}
	}
	
	function _setDefaultValues() {
		if (defaultValues === undefined) {
			return;
		}
	    for (var paramName in defaultValues) {
	    	var defaultValue = defaultValues[paramName];
	    	defaultValue = (typeof defaultValue === 'object' && defaultValue !== null && defaultValue.value !== undefined) ? defaultValue.value : defaultValue;		// backward compatibility
	    	Fields.set(paramName, defaultValue);
	    }
	}
	
	function _initEvents() {
		initCameraEvent();
		initQREvent();
		initBarcodeEvent();
		initFilterable();
	}
	
	function initFilterable() {
		$("[data-input='#filterable-input']").filterable();
	}
	
	function initBarcodeEvent() {
		if ($(".barcode-button").length > 0) {
			$(".barcode-button").click(function() {
				store('SCANNER_TYPE', '{{dataTypeInfo.scanner}}');
				store('APCAMERA_TYPE', 'BARCODE'); 
				store('APCAMERA_RETURN_ELEMENT', $(this).attr("id").replace("_barcode",""));
				window.open('/ServiceManager/res/quagga/example/live_w_locator.html');
			});
		}
	}
	
	function initQREvent() {
		if ($(".qr-button").length > 0) {
			$(".qr-button").click(function() {
				store('APCAMERA_TYPE', 'QR'); 
				store('APCAMERA_RETURN_ELEMENT',  $(this).attr("id").replace("_qr",""));
				window.open('/ServiceManager/res/camera/camera.html');
			});
		}
	}
	
	function initCameraEvent() {
		if ($(".camera-button").length > 0) {
			$(".camera-button").click(function() {
				store('APCAMERA_TYPE', 'FILE'); 
				store('APCAMERA_RETURN_ELEMENT', $(this).attr("id").replace("_camera","")); 
				window.open('./res/camera/camera.html');
			});
		}
	}
	
	function _setFromStorage() {
		for (var i = 0; i < sessionStorage.length; i++) {
	    	var key = sessionStorage.key(i);
	    	var skipKey = false;
	    	for (var j=0; j < excludedKeys.length; j++) {
	    		if (key.indexOf(excludedKeys[j])!= -1) {
	    			skipKey = true;
	    			break;
	    		}
	    	}
	    	if (skipKey) continue;
	    	var value = sessionStorage.getItem(key);
	        populateFieldHTML(key, (value === "null" ? "" : value));
	    }
	}
	
	///////////////////////////////////
    /// Get ///////////////////////////
    ///////////////////////////////////
	
	function _getFromHtml(element) {
		if (element[0].type === "checkbox") {
			return element[0].checked;
		} else if (element.is("input") || element.is("textarea")) {
			return element.val();
		}
		return element.text();
	}
	
	function _get(fieldName) {
		var value;
		var element = $("#" + fieldName);
		if (element.length > 0 && element[0].nodeName !== 'TH') {
			value = _getFromHtml(element);
	    	if (value !== undefined) {
	    		return cleanValue(value);
	    	}
		}
		value = sessionStorage.getItem(fieldName);
		return value !== null ? value.trim() : undefined;
	}
	
	///////////////////////////////////
    /// Store /////////////////////////
    ///////////////////////////////////
	
	function collectInputElements() {
	    var result = new Array();

	    //all input elements
	    var inputArray = document.getElementsByTagName("input");
	    var disallowedInputs = ['submit', 'button', 'file'];

	    //get input fields of allowed types
	    for (var index = 0; index < inputArray.length; index++) {
	        if (disallowedInputs.indexOf(inputArray[index].type) == -1 && !/^_nostore_/.test(inputArray[index].id)) {
	            result.push(inputArray[index]);
	        }
	    }
	    
	    //add textarea elements
	    var textareaArray = document.getElementsByTagName("textarea");
	    for (var index = 0; index < textareaArray.length; index++) {
	        result.push(textareaArray[index]);
	    }

	    //add select elements
	    var selectArray = document.getElementsByTagName("select");
	    for (var index = 0; index < selectArray.length; index++) {
	        result.push(selectArray[index]);
	    }
	    
	    //add dropdowns
	    var dropdowns = $('.dropdown-container > div');
	    for (var index = 0; index < dropdowns.length; index++) {
	    	result.push(dropdowns[index]);
	    };

	    return result;
	}
	
	function _storeAll() {
		inputElementsArray = collectInputElements();
	    
	    for (var index = 0; index < inputElementsArray.length; index++) {
	    	var inputElement = inputElementsArray[index];
	        var itemId = inputElement.id;
	        if (itemId == null || itemId.length == 0) {
	            continue;
	        }
	        var itemValue = inputElement.type === "checkbox" ? inputElement.checked :
	        				inputElement.nodeName.toUpperCase() === "DIV" ? ($(inputElement).attr("value")? $(inputElement).attr("value"): inputElement.innerText) :
	        				inputElement.value;
	        sessionStorage.setItem(itemId, itemValue)
	    }
	}
	
    ///////////////////////////////////
    /// Validation ////////////////////
    ///////////////////////////////////
	
	function ignoreHiddenFieldsInValidation() {
		$('input, div.dropdown-container').each(function(index, element) {
	        var isVisible = $(element).is(':visible');
	        if (!isVisible && element.hasAttribute('required')) {
	            element.removeAttribute('required', '');
	            element.setAttribute('hidden-required', '');
	        } else if (isVisible && element.hasAttribute('hidden-required')) {
	            element.removeAttribute('hidden-required', '');
	            element.setAttribute('required', '');
	        }
	    });
	}
	
	function _validate() {
		ignoreHiddenFieldsInValidation();
		var isValid = $('#mainForm')[0].checkValidity();
		
		// validate date and dropdown fields
		$("input[data-type='DATE'][required], div.dropdown-container[required]").each(function(index) {
			if ($(this).val() === "" && $(this)[0].innerText.trim() === "") {
				$(this).addClass("input-field-invalid-value");
				isValid = false;
			} else {
				$(this).removeClass("input-field-invalid-value");
			}
		});
		
		if (isValid) {
			$('input:invalid').removeClass("input-field-invalid-value");
		} else {
			$('input:invalid').addClass("input-field-invalid-value");
			$("#mainPage").animate({	// scroll to the first invalid element
				scrollTop: $('.input-field-invalid-value').first().offset().top
			},500);
		}
		
		return isValid;
	}
	
	
	///////////////////////////////////
    /// API ///////////////////////////
    ///////////////////////////////////
	
	return {
		clearAll: 			_clearAll,
		clear: 				_clear,
		clearByPrefix: 		_clearByPrefix,
		
		get: 				_get,
		
		initDate:			FieldDate.initDate,
		
		set: 				_set,
		setAndStore: 		_setAndStore,
		setDefaultValues: 	_setDefaultValues,
		initEvents:			_initEvents,
		setFromStorage:		_setFromStorage,
		
		storeAll:			_storeAll,
		
		validate: 			_validate
	};
}();

var FieldText = function() {
	
	///////////////////////////////////
    /// Set ///////////////////////////
    ///////////////////////////////////
	
	function _textFieldHandler(elm) {
		var selectionIndex = elm.selectionStart;
		var formatter = elm.getAttribute("text-formatter").toLowerCase().trim();
		if (formatter === "upper") {
			elm.value = elm.value.toUpperCase();
		} else if (formatter === "lower") {
			elm.value = elm.value.toLowerCase();
		} 
		
		elm.selectionStart = selectionIndex;
		elm.selectionEnd = selectionIndex;

		var pattern = elm.getAttribute("pattern");
		if (pattern && pattern !== "") {
			if (!RegExp(pattern).test(elm.value)) {
				elm.value = elm.value.substr(0, (selectionIndex-1)) + elm.value.substr((selectionIndex-1)+1);
				elm.selectionStart = selectionIndex-1;
				elm.selectionEnd = selectionIndex-1;
			}
		}
	}


	function _populateTextField(fieldElement, fieldValue) {
		var formatter = fieldElement.getAttribute("text-formatter").toLowerCase().trim();
		var pattern = fieldElement.getAttribute("pattern");
		if ((formatter !== "" && formatter !== "none") || (pattern && pattern !== "")) {
			fieldElement.setAttribute ("onkeyup", "FieldText.textFieldHandler(this)");
		}
	}
	
	///////////////////////////////////
    /// API ///////////////////////////
    ///////////////////////////////////
	
	return {
		populateTextField: _populateTextField,
		textFieldHandler: _textFieldHandler
	};
}();
var Files = function() {

	function appendField(formData, field, value) {
		if (value !== undefined) {
			formData.append(field, value);
		}
	}
	
	function _upload(file, filename, path, isAbsolute, field, synced) {
		var formData = new FormData();
		appendField(formData, 'path', path);
		appendField(formData, 'absolute', isAbsolute);	// TODO obsolete?
		
		if (isObject(file)) {
			formData.append('file', file, filename);	//explicitly setting the file name works in IE 11
		} else {
			appendField(formData, 'fileBase64', file);
			appendField(formData, 'filename', filename || '<timestamp>.txt');
		}
		
		return $.ajax({
			url: getServiceManagerHost() + '/ServiceManager/Macro/FileManager',
			data: formData,
			type: 'POST',
			async: !synced,
			contentType: false, // (requires jQuery 1.6+)
			processData: false,
			success: function(response) {
				if (field !== undefined) {
					store(field.id, response.data);
					field.setAttribute("uploaded", true);
				}
			}, error: function(jqXHR, textStatus, errorMessage) {
				Spinner.stop();
				showInfoPopup('File upload failed', errorMessage);
			}
		});
	}
	
	function _uploadString(content, filename, path, synced) {
		return _upload("data:text/plain;base64," + btoa(content), filename, path, synced);
	}
	
	function _uploadNewFiles(synced) {
		Spinner.start();
		var deferred = $.Deferred();
		var deferreds = [];
		
		$('input[type="file"]').each(function(index, field){
			if (field.attributes.uploaded !== undefined && field.attributes.uploaded.value !== "true") {
				store(field.id, '');
				if (field.files.length !== 0 || field.attributes.fileFromCamera !== undefined) {
					var file = field.attributes.fileFromCamera !== undefined ? dataURItoBlob(field.attributes.fileFromCamera.value) : field.files[0];
					var target = field.attributes['data-target'] !== undefined ? field.attributes['data-target'].value : '';
					var path = !isEmpty(target) ? target : 'www/upload';
					if (!synced) {
						deferreds.push(_upload(file, file.name, path, target !== '', field));
					} else {
						_upload(file, file.name, path, target !== '', field, synced);
					}
					
				}
			}
		});
		
		if (!synced) {
			$.when.all(deferreds).then(function(objects) {
				Spinner.stop();
			    deferred.resolve();
			});
			return deferred.promise();
		} else {
			return true;
		}
	
	}
	
	function dataURItoBlob(dataURI) {
	    var byteString = atob(dataURI.split(',')[1]);
	    var ab = new ArrayBuffer(byteString.length);
	    var ia = new Uint8Array(ab);
	    for (var i = 0; i < byteString.length; i++) {
	        ia[i] = byteString.charCodeAt(i);
	    }
	    return new Blob([ab], { type: 'image/jpeg' });
	}
	
	if (typeof jQuery.when.all === 'undefined') {
	    jQuery.when.all = function (deferreds) {
	        return $.Deferred(function (def) {
	            $.when.apply(jQuery, deferreds).then(
	                function () {
	                    def.resolveWith(this, [Array.prototype.slice.call(arguments)]);
	                },
	                function () {
	                    def.rejectWith(this, [Array.prototype.slice.call(arguments)]);
	                });
	        });
	    }
	}
	
	$(document).ready(function(){
	    $("input[type=file]").click(function(){
	        $(this).val("");
	        document.getElementById(this.id + '_filename').innerHTML = '(No file)';
	    });
	
	    $("input[type=file]").change(function(){
	        this.setAttribute("uploaded", false);
	        this.removeAttribute("fileFromCamera");
	        document.getElementById(this.id + '_filename').innerHTML = this.files[0].name;
	        $(this).blur();
	    });
	});

	///////////////////////////////////
	/// API ///////////////////////////
	///////////////////////////////////
	
	return {
		upload:				_upload,
		uploadString:		_uploadString,
		uploadNewFiles:		_uploadNewFiles
	};
}();

function executeHandler(handler) {
    if (handler == undefined) {
        return;
    }

    if (handler["preFunction"] != undefined) {
        executeCallFunctionHandler(handler["preFunction"], arguments);
    }
    
    if (/function$/.test(handler["action"])) {	//handler["action"].endsWith("function")
        executeCallFunctionHandler(handler['attr'], arguments);
        
    } else if (/webservice$/.test(handler["action"]) || handler["action"] == "onload") {
    	callWebServiceWithAllParams(handler['attr'], handler['initHandler'], handler['responseHandler'], handler['failureHandler'], true, true);

    } else if (/navigate$/.test(handler["action"])) {
        navigate(handler['attr']);
    }
}

function executeCallFunctionHandler(funcName, outerArguments) {
    if (window[funcName] == undefined) {
        alert("Undefined function: " + funcName);
    } else {
        window[funcName].apply(undefined,
            arguments.length > 1 ? Array.prototype.slice.call(outerArguments, 1) : undefined);
    }
}

function getHandlersByFilter(handlerMap, filter) {
    if (handlerMap == undefined) {
        return [];
    }

    return $(handlerMap).filter(function (index, handler) {
        return objFilter(handler, filter);
    });
}

//utility function, used by getHandlersByFilter
function objFilter(obj, filter) {
    var result = true;

    for (key in filter) {
        result &= obj[key] == filter[key];
    }

    return result;
}

function getServiceManagerHost() {
	return 	typeof app !== 'undefined' && app.serviceManagerHost != undefined && app.serviceManagerHost != null ?
			app.serviceManagerHost.trim().replace(/\/$/, '') :
			'';
}


//GLOBALS
var spa_entryFragment;
var waitingForResponse = false;
var handlerMap;
var columnsMetadata;
var inputElementsArray = null;
var data = {};		//TODO unused?
window.lastFocusedElement = null;

var Init = function() {
	
	function initEventHandlers() {
		$(document).on("sendRequest", function () {
	        if (window["sendRequestHandler"] != undefined) {
	            window["sendRequestHandler"].call(this);
	        }
	    });

	    $(document).on("receiveResponse", function (event, response, serviceName, status, populateFields) {
	        if (window["receiveResponseHandler"] != undefined) {
	            window["receiveResponseHandler"].call(this, response, serviceName, status, populateFields);
	        }
	    });

	    $(document).on("pageInitialized", function () {
	        if (window["pageInitializedHandler"] != undefined) {
	            window["pageInitializedHandler"].call(this);
	        }
	    });
	}
	
	function executeOnLoadHandlers() {
		var onloadFunctions = [];
		$.merge(onloadFunctions, getHandlersByFilter(handlerMap, {"action": "onload"}));
		$.merge(onloadFunctions, getHandlersByFilter(handlerMap, {"action": "onload:navigate"}));
		$.merge(onloadFunctions, getHandlersByFilter(handlerMap, {"action": "onload:function"}));
		for (var i = 0; i < onloadFunctions.length; i++) {
			executeHandler(onloadFunctions[i]);
		}
		$(document).triggerHandler("pageInitialized");
	}
	
	function loadHandlersWithAjax() {
		var creationTimestamp = $('meta[name="Creation-Timestamp"]').attr("content");
	    if (creationTimestamp == undefined) {
	        alert("Error: Meta tag Creation-Timestamp is missing");
	    }
	    var jsonFile = 'handlerMap_' + creationTimestamp + '.json';
		
		$.ajax({
	        url: 'json/' + jsonFile,	// no need for getServiceManagerHost() since this is method is used only by old versions
	        //async: false,
	        dataType: 'text',
	        timeout: Services.getTimeout(),
	        success: function (response) {
	        	if (/^handlerMap=/.test(response)) {	// response.startsWith('handlerMap=')
	        		response = response.substring('handlerMap='.length, response.length - ';'.length);
	        	}
	        	handlerMap = JSON.parse(response);
	        	executeOnLoadHandlers();
	        },
	        error: function () {
	            alert("Error loading handler map " + jsonFile);
	        }
	    });
	}
	
	function initOnBlurListeners() {
		
		//initialize on-blur event for inputs to check validity
		$("input[type='number'],input[type='email'],input[type='text'],input[data-type='DATE']").blur(function () {
	      	 var textErrorid = "ValidationErrorText_" + this.id;
	      	 $("#" + textErrorid).remove();
      		 $(this).removeClass("input-field-invalid-value");

      		 //This will add error message to any field with invalid value
			 //Except for the case that it is required field with empty value
			 //The error message presented will be the field title or generic message
	      	 if ( !this.checkValidity() && !this.validity.valueMissing) {
	      		 $(this).addClass("input-field-invalid-value");
		    	 var errorMessage = this.title || "Invalid value";
				 $("<div class='validation-error-text-container' id=" + textErrorid + " style='color:red'>" + errorMessage + "</div>").insertAfter($(this));
	      	 }
	    });
	}
	
	function initClickListeners() {
	    //initialize on-click event for buttons
	    $("button").on("click", function () {
	    	if ($(this).parent().hasClass("validate-required") && !Fields.validate()) {
	    		return;
	    	} else {
	    		$('input:invalid').removeClass("input-field-invalid-value");
	    	}
	    	 
	        var handlers = getHandlersByFilter(handlerMap, {"elementId": $(this).attr('id')});
	        for (var i = 0; i < handlers.length; i++) {
	        	executeHandler(handlers[i]);
	        }
	    });
	    
	    //initialize dropdown behavior: when one dropdown opens, close any other dropdowns
	    $('.ui-input-text,span[id$="_container"]:has(div.dropdown-container)').click(function() {
			var self = this;
			$('div.ui-autocomplete-input').each(function (i, e){
				if (!$(e).is($(self)) && $(self).has($(e)).length == 0){
					if ($(e)) $(e).autocomplete('close');
				}
			})
		});

	    $(document).mousedown(function(e) {
	    	var event = e;
	    	$('div.ui-autocomplete-input').each(function (i, e){
	    		var container = $(e);
		    	if ((!container.is(event.target) && container.has(event.target).length === 0) &&
		    			!event.target.classList.contains("ui-autocomplete") && $(".ui-autocomplete").has(event.target).length == 0) {
		    		container.autocomplete('close');
		    	}
			})
	    });
	    
	    //initialize key-down event
	    $(document).keydown(function (e) {
	        var keyId = e.which;
	        window.lastFocusedElement = e.target;
	        var targetId = e.target.id;
	        var handlers = getHandlersByFilter(handlerMap, {"key": keyId});

	        for (var i = 0; i < handlers.length; i++) {
	            //element not specified, execute
	            if (handlers[i]["elementId"] == undefined ||
	                handlers[i]["elementId"] == "") {
	                executeHandler(handlers[i]);
	            }
	            //element matches rule, execute
	            else if (handlers[i]["elementId"] == targetId) {
	                executeHandler(handlers[i]);
	            }
	        }
	        
	        if (keyId === 27) {
	        	$('div.ui-autocomplete-input').each(function (i, e){
	        		if ($(e)) $(e).autocomplete('close');
				})
	        }
	    });
	}
	
	function checkMockFlags() {
		var queryParams = Page.parseQuery();
		var mock = Object.keys(queryParams).indexOf('mock') !== -1 ? queryParams['mock'].toUpperCase() : undefined;
		var recordMock = Object.keys(queryParams).indexOf('recordMock') !== -1 ? queryParams['recordMock'].toUpperCase() : undefined;
		if (recordMock === 'TRUE' || recordMock === 'FALSE') {
			Storage.set("recordMock", recordMock === 'TRUE');
		} else if (mock === 'TRUE' || mock === 'FALSE') {
			Storage.set("mock", mock === 'TRUE');
		}
		if (Storage.get('mock') === 'true' || Storage.get('recordMock') === 'true') {
			$('#mockIndicator').css('display', 'block');
			if (Storage.get('recordMock') === 'true') {
				$('#mockIndicator').text('mock recording');
			}
		} 
	}
	
	function _setLogoutMenu() {
		function menuLogoutCb() {
			setTimeout(function() {
		        Popup.custom((app.logoutTitle || "Logout"), 
		        			 (app.logoutMessage||"Are you sure you want to logout?"), 
		        			 (app.logoutYesButton || "Yes"), (app.logoutNoButton || "No"), 
		        			 function(){
		        				if (app.logoutCallback && typeof app.logoutCallback === "function") {
		        					app.logoutCallback();
		        				} else {
			        				Services.killSession();
			        				Storage.clear();
							        Page.navigate(app.loginPage);
		        				}
						    }, null);
			}, 200);
		}

		if (typeof app !== 'undefined' && (!app.addLogoutToMenu || app.loginPage === "")) {
			$("#menu-item-Logout").hide();
			var menuItemsNoBeforeLogout = $("#leftpanel li").length - 2;
			if (menuItemsNoBeforeLogout >= 0) {
				$($("#leftpanel li")[menuItemsNoBeforeLogout]).attr("class","ui-last-child");
			}
		} else {
			$("#menu-item-Logout").show();
			$("#menu-item-Logout > span").text(app.logoutTitle || "Logout");
			$("#menu-item-Logout").click(menuLogoutCb);
		}
		
	}
	
	function _initData() {
		setUserDataValuesInFields();
	    initTableOrList();
	    populateTableOrList(true);

	    //set fields from query string into user data
	    var qs = Page.parseQuery();
	    for (param in qs) {
	        populateField(param, qs[param]);
	    }

	    initEventHandlers();
	    initClickListeners();
	    initOnBlurListeners();

	    _setLogoutMenu();
	    
	    Events.pageChanged();
	    
	    if (typeof window['handlerMap'] === "object") {
	    	executeOnLoadHandlers();
	    	checkMockFlags();
	    } else {
	    	loadHandlersWithAjax();		//backward compatibility
	    }
	}

	(function addIEPollyFills() {
		if (/MSIE \d|Trident.*rv:/.test(navigator.userAgent)) {
			var head = document.getElementsByTagName('head')[0];
			var js = document.createElement("script");
			js.type = "text/javascript";
		    js.src = "res/bluebird/bluebird.min.js";
		    head.appendChild(js);
		}		
	})();
	
	return {
		initData:			_initData
	};
}();

// We need to wait for readyState === 'complete' AND use setTimeout for SPA loading
$.prototype.ready = function (func) {
	var interval = setInterval(function() {
	    if(document.readyState === 'complete') {
	        clearInterval(interval);
	        setTimeout(function() {		// required so SPA fragments will execute $(document).ready() only AFTER the fragment is fully loaded
	    		func();
	        });
	    }    
	}, 100);
};

function getSuppressedParams() {
	return typeof app !== 'undefined' && isArray(app.serviceSuppressedParams) ? app.serviceSuppressedParams : [];
}

function generateHeaders() {
	var $ = {};
	$['AP-No-Challenge'] = true;
	
	var regex = new RegExp('^' + '_header_');
	Object.keys(sessionStorage).forEach(function(key) {
		if (regex.test(key)) {
			$[key.substr('_header_'.length)] = sessionStorage.getItem(key);
		}
	});
	return $;
}

function getInputFieldsAsQueryString(serviceName, async) {
    saveUserData();
    var metaDataPromise = Promise.resolve(true);
    var suppressed = getSuppressedParams();
    suppressed.splice(suppressed.length, 0, '_backup', '_header_', '_okta_', 'ls\\.', 'serviceManagerLocalStorage\\.', 'Error', 'PopupMessages', 'StatusBarMessages');
    suppressed = new RegExp('^(' + suppressed.join('|') + ')');
    
    if (serviceName) {
    	metaDataPromise = Metadata.getServiceMetaData(serviceName, async);
    }
   
    return async ? 
    	   metaDataPromise.then(function() {
    		   return addKeyValueToQuery(suppressed, serviceName).join("&");
    	   }).catch(function(err){
    		   return addKeyValueToQuery(suppressed, serviceName).join("&");
    	   }) :
    	   addKeyValueToQuery(suppressed, serviceName).join("&") ;
}

function addKeyValueToQuery(suppressed, serviceName) {
	var queryArray = new Array();
    for (var i = 0; i < sessionStorage.length; i++) {
    	var key = sessionStorage.key(i);
        if (!suppressed.test(key) && (serviceName === undefined || Metadata.isRequiredWebServiceParam(serviceName, key))){
        	var value = sessionStorage.getItem(key);
        	value = (value !== null ? encodeURIComponent(value) : "");
        	queryArray.push(key + "=" + value);
        }
	}
	queryArray.push("requestId" + "=" + new Date().getTime());
    return queryArray;
}

function getResponseNodeValueByName(nodeName, response) {
    if (window.response == null && response == null) {
        return "";
    } else if (typeof response === 'undefined' || response == null) {
        response = window.response;
    }

    return findValues(response, nodeName)[0] || "";
}

function copyToNextAvailableIndex(paramName, startIndex) {
	var nameWoIndex = paramName.substr(0, getNameWoIndexLength(paramName));
	for (var i = startIndex;; i++) {
		var currentName = nameWoIndex + '_' + i;
		if (!sessionStorage.contains(currentName)) {
			sessionStorage[currentName] = sessionStorage[paramName];
			return;
		}
	}
}

/* Refactored */
/* resolveAddress requires Google Maps API key */

var Location = function(){
	var map, geocoder, marker;
	
	return {
		
		initMap: function() {
		    map = new google.maps.Map(document.getElementById('map'), {
		    	center: {lat: 40.7115648, lng: -74.0038266},
		    	zoom: 12,
		    	gestureHandling: "cooperative",
		    	fullscreenControl: false,
		    	streetViewControl: false
		    });
		    geocoder = new google.maps.Geocoder();
		    
		    var initialAddress = this.buildAddress();
		    if (!initialAddress || initialAddress.length == 0) {
		    	initialAddress = defaultValues['Map'];
		    	initialAddress = (typeof initialAddress === 'object' && initialAddress !== null && initialAddress.value !== undefined) ? initialAddress.value : initialAddress;		// backward compatibility
		    	document.getElementById('map_address').innerHTML = initialAddress;
			}
		    this.markOnMap(initialAddress);
		    
		    var that = this;
			document.getElementById('map_navigate_button').addEventListener('click', function() {
				var address = document.getElementById('map_address').innerHTML;
				var url = 'https://www.google.com/maps/search/?api=1&query=' + address.replace(' ', '+');
				window.open(url, '_blank');
			});
		    document.getElementById('map_locate_button').addEventListener('click', function() {
		    	that.markOnMap(that.buildAddress(), true);
			});
		},
		
		buildAddress: function() {
			var address = window['convert_map']();
			document.getElementById('map_address').innerHTML = address;
			return address.trim();
		},
		
		markOnMap: function(address, popupOnFailure) {
			if (marker !== undefined) {
				marker.setMap(null);
			}
			if (!address || address.length == 0) {
				return;
			}
			geocoder.geocode({'address': address}, function(results, status) {
				if (status === 'OK') {
					map.setCenter(results[0].geometry.location);
					marker = new google.maps.Marker({
						map: map,
						position: results[0].geometry.location
					});
				} else {
					if (popupOnFailure) {
						showInfoPopup('Map', 'Unable to resolve address: ' + status);
					}
				}
			});
		},
		
		getCurrentPosition: function(callback) {
			var options = {
		        enableHighAccuracy: true,
		        timeout: 5000,
		        maximumAge: 0
		    };

		    if (navigator.geolocation) {
		        navigator.geolocation.getCurrentPosition(callback, null, options);
		    } else {
		    	Popup.info('Location Error', 'Location unavailable on this device/browser.');
		    }
		},
		
		resolveAddress: function(callback, position) {
			var url = "http://maps.googleapis.com/maps/api/geocode/json?latlng=" + position.coords.latitude + "," + position.coords.longitude + "&language=en&sensor=false";
		    jQuery.getJSON(url, function (json) {
		    	if (json.error_message !== undefined && json.error_message.length > 0) {
		    		Popup.info('Location Error', json.error_message);
		    		return;
		    	}
		    	
		        var res = {};
		        //normalize google repsponse
		        $.each(json['results'][0]['address_components'], function (i, elem) {
		            res[elem['types'][0]] = elem['long_name']
		        });

		        callback(res);
		    });
		}
	};
}();

function initMap() {	// must be kept for GoogleMaps API url callback function (which cannot have dot in it's name)
	Location.initMap();
}

var Lov = function() {
	var lov_elementIds = {};			// maps [serviceName] to [array with names of elementIds using the service]
	var lov_labelItemPairs = {};		// maps [serviceName] to [array with labelItemPairs of service's autocomplete]
	var suggestions_in_progress = [];
	
	///////////////////////////////////
    /// Infinite scroll ///////////////
    ///////////////////////////////////
	
	function isScrollbarBottom(container) {
        var height = container.outerHeight();
        var scrollHeight = container[0].scrollHeight;
        var scrollTop = container.scrollTop();
        if (scrollTop >= scrollHeight - height) {
            return true;
        }
        return false;
    }
	
	function scrollNext(ul, self, items, maxShow, results, pages) {
		$(ul).scroll(function () {
			if (isScrollbarBottom($(ul))) {
				++self.scrollPaginationIndex;
				if (self.scrollPaginationIndex >= pages) {
				    return;
				}
				results = items.slice(self.scrollPaginationIndex * maxShow, self.scrollPaginationIndex * maxShow + maxShow);
				$.each(results, function (index, item) {    //append item to ul
					self._renderItem(ul, item).data("ui-autocomplete-item", item);
				});
				self.menu.refresh();
				ul.show();
				self._resizeMenu();
				ul.position($.extend({
					of: self.element
				}, self.options.position));
				if (self.options.autoFocus) {
					self.menu.next(new $.Event("mouseover"));
				}
			}
		});
    }
	
	function initInfiniteScroll(element) {
		element.data("ui-autocomplete")._renderItem = function(ul, item) {
			var $a = $("<a></a>").text(item.label);
			highlightText(this.term, $a);
			return $("<li></li>").append($a).appendTo(ul);
		};
		element.data("ui-autocomplete")._renderMenu = function (ul, items) {	// required for scroll pagination
			$(ul).unbind("scroll");	//remove scroll event to prevent attaching multiple scroll events to one container element
			this.scrollPaginationIndex = 0;
			this._scrollMenu(ul, items);
		};
		element.data("ui-autocomplete")._scrollMenu = function (ul, items) {	// scroll pagination: opens maxShow=10 first suggestions, and adds more as the user scrolls
			var self = this;
			var maxShow = 10;
			var results = items.slice(0, maxShow);
		    var pages = Math.ceil(items.length / maxShow);

			if (pages > 1) {
			    scrollNext(ul, self, items, maxShow, results, pages);
			}
			$.each(results, function (index, item) {
				self._renderItem(ul, item).data("ui-autocomplete-item", item);
			});
		}
	}
	
	///////////////////////////////////
    /// Focus & button triggers ///////
    ///////////////////////////////////
	
	function initAutocompleteFocusTrigger(elementId, serviceName) {
		var handler = function() {
			if (lov_labelItemPairs[serviceName] !== undefined) {
				if (!$('#' + elementId).hasClass('ui-autocomplete-input')) {
					Lov.setAutocomplete(elementId, serviceName, lov_labelItemPairs[serviceName]);
				}
				return;
			}
			Lov.getSuggestions(elementId, serviceName);
		};

		var field = $('#' + elementId);
		if (field[0].nodeName === 'DIV') {
			$(field[0].parentElement).click(handler);
		} else {
			field.focusin(handler);
		}
	}
	
	function _reloadSuggestions(elementId, serviceName) {
		_clearSuggestions(serviceName);
		Lov.getSuggestions(elementId, serviceName);
	}

	function initAutocompleteButton(elementId, serviceName) {
		$('#' + elementId + '_lov_trigger').click(function () {
			_reloadSuggestions(elementId, serviceName);
		});
	}
	
	///////////////////////////////////
    /// Service call //////////////////
    ///////////////////////////////////
	
	function prepareAutocompleteRequestParams(elementId, serviceName) {
		var requestPreparer = window["prepare_" + serviceName + "_lov_request"];
		if (typeof requestPreparer === 'undefined') {	// backward compatibility
			requestPreparer = window["prepare_" + elementId + "_lov_request"];
		}
		
		if (typeof requestPreparer !== 'undefined') {
			var inputParams = requestPreparer();
			var inputParamArray = [];
			for (var paramName in inputParams) {
				if (inputParams.hasOwnProperty(paramName) && inputParams[paramName] !== undefined) {
					inputParamArray.push(paramName + "=" + encodeURIComponent(inputParams[paramName]));
				}
			}
			var sessionId = sessionStorage.getItem("sessionId");
			if (sessionId !== null) {
				inputParamArray.push("sessionId=" + sessionId);
			}
			if (Storage.get("mock") === "true") {
				inputParamArray.push("mock=true");
			}
			return inputParamArray.join("&");
		} else {
			return "";
		}
	}
	
	function onSuggestionsSuccess(response, serviceName, arrayItems) {	
		console.log('Received ' + arrayItems.length + ' autocomplete suggesstions from service ' + serviceName);
		
		presentAutocompleteItems(serviceName, arrayItems, this.showAutoComplete);
		suggestions_in_progress.splice(suggestions_in_progress.indexOf(serviceName), 1);
		Spinner.stopMiniSpinner();
	}

	function onSuggestionsError(response, serviceName) {
		var serviceErrorMsg = getResponseNodeValueByName("Error");
		if (serviceErrorMsg != undefined && serviceErrorMsg.length > 0) {
			setTimeout(function () {
		        Popup.serviceErrors(serviceErrorMsg, 200);
		    }, 1000);
		}
		
		suggestions_in_progress.splice(suggestions_in_progress.indexOf(serviceName), 1);
		Spinner.stopMiniSpinner();
	}
	
	///////////////////////////////////
    /// Present & Select //////////////
    ///////////////////////////////////
	
	function presentAutocompleteItems(serviceName, arrayItems, showAutoComplete) {
		for (var i = 0; i < lov_elementIds[serviceName].length; i++) {
			var elementId = lov_elementIds[serviceName][i];
			var itemPresenter = window[(inTable(elementId) ? getNameWoIndex(elementId) : elementId) + "_lov_item_presenter"];
			if (typeof itemPresenter === "undefined") {
				continue;
			}
			var autocompleteOptions = [];
			arrayItems.forEach(function(arrayItem) {
				var presented = itemPresenter(arrayItem);
				if (presented !== undefined && presented !== null && isString(presented)) {		// backward compatibility
					presented = {label: presented, value: presented};
				}
				if (presented === undefined || presented === null || presented.label.trim() === "") {	// filter items omitted by the xxx_lov_item_presenter and empty labels
					return;		// skip to next suggestion
				} 
				autocompleteOptions.push({label: presented.label, value: presented.value, item: arrayItem});
			});
			Lov.setAutocomplete(elementId, serviceName, autocompleteOptions, i !== 0 || showAutoComplete === false);
		}
	}
	
	function highlightText(text, $node) {
		text = $.trim(text);
		if (text === '') {
			return;
		}
		var searchText = text.toLowerCase(), currentNode = $node.get(0).firstChild, matchIndex, newTextNode, newSpanNode;
		if (currentNode && currentNode.data) {
			while ((matchIndex = currentNode.data.toLowerCase().indexOf(searchText)) >= 0) {
				newTextNode = currentNode.splitText(matchIndex);
				currentNode = newTextNode.splitText(searchText.length);
				newSpanNode = document.createElement("span");
				newSpanNode.className = "highlight";
				currentNode.parentNode.insertBefore(newSpanNode, currentNode);
				newSpanNode.appendChild(newTextNode);
			}
		}
	}
	
	function setAutocompleteSelectOnBlur(element, serviceName) {
		element.blur(function(event) {
			
			var autocomplete = $(this).data("ui-autocomplete");
	        var suggestions = autocomplete.widget().children(".ui-menu-item");
	        
	        if (autocomplete.selectedItem !== null) {	// if the user clicked on a suggestion, then focused out
	        	return;
	        }
	        
	        if (suggestions.length === 0 || $(this).val() === '') {
	        	// careful: when there is NO match, length will be the count of ALL dropdown items.
	        	// besides that, when there IS match, length will be the count of possible autocomplete suggestions.
	        	$(this).val('');
	        	return;
	        }
	        
	        var matcher = new RegExp($.ui.autocomplete.escapeRegex($(this).val()), "i");
	        
	        // when there is NO match, suggestions will contain ALL dropdown items.
	        if (suggestions.length > 0 && !matcher.test(suggestions[0].innerText)) {
	        	$(this).val('');
	        	return;
            }
	        
	        // if there is exact match, select it. Otherwise select the first suggestion 
	        var i = 0;
	        for (var i = 0; i < suggestions.length; i++) {
	        	if (suggestions[i].innerText === $(this).val()) {
	        		break;
	        	}
	        }
	        if (i === suggestions.length) {
	        	i = 0;
	        }
			
        	invokeOnSelectCallback(element[0].id, serviceName, $(suggestions[i]).data().uiAutocompleteItem);
	    });
	}
	
	function invokeOnSelectCallback(elementId, serviceName, selected) {
		var itemHandler = window[elementId + "_lov_item_handler"];
		if (typeof(itemHandler) === 'undefined') {
			return;
		}
		
		if (/^_static_lov_/.test(serviceName)) {		//serviceName.startsWith('_static_lov_')
			itemHandler(selected.item, selected.label);
		} else {
			itemHandler(selected.item);
		}
	}
	
	///////////////////////////////////
    /// Suggestions API ///////////////
    ///////////////////////////////////
	
	function _clearSuggestions(serviceName) {
		lov_labelItemPairs[serviceName] = undefined;		// maybe we should also iterate all lov_elementIds[serviceName] and clear the autocomplete?
															// currently, if user hits clearSuggestions() but service fails when field is clicked - old suggestions will still be present
		deleteOfflineResponse(serviceName);
	}
	
	function _getSuggestions(elementId, serviceName, showAutoComplete) {
		if (suggestions_in_progress.indexOf(serviceName) != -1) {
			console.log('Aborting: getSuggestions is already in progress!');
			return;
		}
		Spinner.startMiniSpinner('Loading suggestions..');
		suggestions_in_progress.push(serviceName);
		showAutoComplete = showAutoComplete !== undefined ? showAutoComplete : true;
		if (showAutoComplete)
			$('#' + elementId).focus();
		
		lov_labelItemPairs[serviceName] = {};
		lov_elementIds[serviceName].splice(lov_elementIds[serviceName].indexOf(elementId), 1);
		lov_elementIds[serviceName].unshift(elementId);
		
		callWebService(serviceName, prepareAutocompleteRequestParams(elementId, serviceName), undefined, onSuggestionsSuccess.bind({showAutoComplete: showAutoComplete, elementId:elementId }), onSuggestionsError, true, false, 'lov:' + elementId);
	}
	
	///////////////////////////////////
    /// Init API //////////////////////
    ///////////////////////////////////
	
	function _initDynamic(elementId, serviceName) {
		if (serviceName === '') {
			alert('Obsolete StaticLOV init, regenerate the app to refesh.');
			return;
		}
		
		if (lov_elementIds[serviceName] === undefined) {
			lov_elementIds[serviceName] = [];
		}
		lov_elementIds[serviceName].push(elementId);
		
		initAutocompleteFocusTrigger(elementId, serviceName);
		initAutocompleteButton(elementId, serviceName);
	}
	
	function _initStatic(elementId, _lov_labelItemPairs, isTableHeader) {
		var serviceName = '_static_lov_' + (inTable(elementId) ? getNameWoIndex(elementId) : elementId);
		
		if (_lov_labelItemPairs !== undefined) {
			lov_labelItemPairs[serviceName] = _lov_labelItemPairs;
		}
		if (!isTableHeader) {
			Lov.setAutocomplete(elementId, serviceName, lov_labelItemPairs[serviceName], true);
		}
	}
	
	///////////////////////////////////
    /// Set Suggestions API ///////////
    ///////////////////////////////////
	
	function populateInTableLov(elementId, serviceName, selected) {
		populateFieldHTML(elementId, selected.label !== undefined ? selected.label : selected.value);
		store(elementId, selected.value);
		store(getNameWoIndex(elementId) + '_current', elementId);
		invokeOnSelectCallback(getNameWoIndex(elementId), serviceName, selected);
	}
	
	function _setAutocomplete(elementId, serviceName, labelItemPairs, keepClosed) {
		lov_labelItemPairs[serviceName] = labelItemPairs;

		element = $("#" + elementId);
		if (element[0].nodeName === "DIV") {
			element = $(element[0].parentElement);
		}

		element.autocomplete({
			source: labelItemPairs,
			minLength: 0,
			selectFirst: true,
			select: function(event, ui) {
				if (inTable(elementId)) {
					populateInTableLov(elementId, serviceName, ui.item);
				} else {
					invokeOnSelectCallback(elementId, serviceName, ui.item);
					if (!ui.item) {
						return false;
					}
					var value = !ui.item.item ?	ui.item.value :
								typeof ui.item.item === 'object' ?
								 ui.item.item[Object.keys(ui.item.item)[0]] :
								 ui.item.item;
					$("#" + elementId).attr("value", value);
					$("#" + elementId).html(ui.item.label);
				}
				return false;
			}
		})
		.off('click')
		.click(function() {
			if ($('.ui-autocomplete.ui-widget:visible').length == 0) {
				$(this).autocomplete("search", $(this).val());
			} else {
				$(this).autocomplete("close");
			}
			
		});
		
		initInfiniteScroll(element);
		
		if (element.data('closed-selection') !== undefined) {
			setAutocompleteSelectOnBlur(element, serviceName);
		}
		
		if (!keepClosed && labelItemPairs.length > 0) {
			element.autocomplete("search", element.val());
		}
	}
	
	///////////////////////////////////
    /// API ///////////////////////////
    ///////////////////////////////////
	
	return {
		clearSuggestions: 	_clearSuggestions,
		getSuggestions: 	_getSuggestions,
		reloadSuggestions:	_reloadSuggestions,
		
		initDynamic: 		_initDynamic,
		initStatic: 		_initStatic,
		
		setAutocomplete: 	_setAutocomplete
	};
}();

var Metadata = function() {
	
	var metaData = initMetadata();
	var urls = {
			appMetaDataURL: "AppMeta/" ,
			serviceMetaDataURL: "ExecMacro/" ,
	};
	
	function initMetadata() {
		return {
			inputFields :[],
			SPECIAL_INPUT_FIELDS: [],
			envFields: []
		};
	}
	
	function _init(appName) {
		if (sessionStorage.getItem("_" +"metadataRetrieved" + App.getName()) == "true") {
			metaData = JSON.parse(sessionStorage.getItem("_metadata"));
			return;
		}
			
		sendMetadataRequest(urls.appMetaDataURL +  App.getName(), {"meta": "true"}, true, function(result) {
			setAppMetadata(result);
		},
		function(result) {
			setAppMetadata(false)
		});
	}
	
	function sendMetadataRequest(url, queryData, asyncFlag,  responseHandler, failureHandler) {
		waitingForResponse = true;
		return $.ajax({
			context: this,
	        url: getServiceManagerHost() + "/ServiceManager/Macro/" + url,
	        headers: generateHeaders(),
	        type: "POST",
	        timeout: Services.getTimeout(),
	        dataType: "json", // expected format for response
	        data: queryData,
	        async: typeof asyncFlag === 'undefined' ? true : asyncFlag,
	        success: function (response, textStatus, xhr) {
	        	waitingForResponse = false;
	        	if (response.errors && response.errors.length > 0) {
	        		failureHandler(response);
	        	}
	        	if (response && response.data) {
	        		responseHandler(response.data);
	        	} else {
	        		failureHandler(response);
	        	}
	        },
	        error: function (response, status, error) {
	        	waitingForResponse = false;
	        	if (failureHandler) {
	        		failureHandler(response);
	        	}
	        	
	        }
	    });
	}
	
	function setAppMetadata(data) {
		metaData = data;
		if (!sessionStorage.getItem("_metadata")) {
			sessionStorage.setItem("_metadata", JSON.stringify(metaData));
		} else {
			var currMetaData = JSON.parse(sessionStorage.getItem("_metadata"));
			metaData = {};
			metaData["inputFields"] = $.extend(true, currMetaData["inputFields"], data["inputFields"]);
			metaData["SPECIAL_INPUT_FIELDS"] = $.extend(true, currMetaData["SPECIAL_INPUT_FIELDS"], data["SPECIAL_INPUT_FIELDS"]);
			metaData["envFields"] = $.extend(true, currMetaData["envFields"], data["envFields"]);
			sessionStorage.setItem("_metadata", JSON.stringify(metaData));
		}
		
		sessionStorage.setItem("_" +  "metadataRetrieved" + App.getName(), true);
	}
	
	function setServiceMetadata(serviceName, data) {
		if (!metaData) {
			metaData = initMetadata();
		}
		metaData.inputFields[serviceName] = data.inputFields;
		sessionStorage.setItem("_metadata", JSON.stringify(metaData));
		return true;
	}
	
	function _getServiceMetaData(serviceName, async) {
		if (metaData && metaData.inputFields && metaData.inputFields[serviceName] !== undefined){
			return async? Promise.resolve(metaData.inputFields[serviceName]): metaData.inputFields[serviceName];
		} else {
			return sendMetadataRequest(urls.serviceMetaDataURL + serviceName+ "?Meta", {"meta": "true"}, async,
			function(result) {
				setServiceMetadata(serviceName, result);
			}).then(function(){
				return metaData.inputFields[serviceName];
			});
		}
	}
	
	function _isRequiredWebServiceParam(serviceName, param) {
		if (metaData == false) {
			return true;
		}
		var sharedInputFields = metaData.SPECIAL_INPUT_FIELDS;
		var envFields = metaData.envFields;
		
		if (sharedInputFields.indexOf(param) !== -1 || envFields.indexOf(param) !== -1 || !serviceName || metaData.inputFields[serviceName] === undefined) {
			return true;
		}
		
		return metaData.inputFields[serviceName].indexOf(param) !== -1;
	}
	
	function _getTransactionId() {
		return metaData.transactionId;
	}
	
	
	///////////////////////////////////
    /// API ///////////////////////////
    ///////////////////////////////////
	
	return {
		init:							_init,
		isRequiredWebServiceParam:		_isRequiredWebServiceParam,
		getServiceMetaData: 			_getServiceMetaData,
		getTransactionId:				_getTransactionId
	}
}();

var Offline = function() {
	
	/*********************************
	 *** Is supported / get config ***
	 *********************************/
	
	function _isSupported() {
		return typeof(localStorage) !== "undefined";
	}
	
	function _getOfflineConfig(serviceName) {
		var allConfig = typeof(offlineConfig) !== "undefined" && offlineConfig instanceof Array ? offlineConfig : [];
		for (var i = 0; i < allConfig.length; i++) {
			if (allConfig[i].service === serviceName) {
				return allConfig[i];
			}
		}
		return {};
	}
	
	/*********************************
	 *** Request *********************
	 *********************************/
	
	function _onOfflineRequest(serviceName, url, query) {
		var config = _getOfflineConfig(serviceName);
		switch (config.action) {
		case 'ERROR':
			showInfoPopup('Offline', 'Please try again later.');
			break;
		case 'STORAGE_THEN_LIVE':
			// will never get here
			break;
		}
	}
	
	/*********************************
	 *** Response ********************
	 *********************************/
	
	function omitSessionId(serviceName, response) {
		try {
			delete response.Response[serviceName + 'Message']['sessionId'];
		} catch (e) {}
		return response;
	}
	
	function _storeResponse(serviceName, response) {
		var offlineAction = _getOfflineConfig(serviceName).action;
		if (offlineAction === 'STORAGE_THEN_LIVE' || offlineAction === 'LIVE_THEN_STORAGE') {
			response = omitSessionId(serviceName, response);
			localStorage['offlineRes_' + serviceName] = JSON.stringify(response);
		}
	}
	
	function _loadResponse(serviceName) {
		var offlineAction = _getOfflineConfig(serviceName).action;
		if (offlineAction === 'STORAGE_THEN_LIVE') {
			var response = localStorage['offlineRes_' + serviceName];
			if (response !== undefined) {
				return JSON.parse(response);
			}
		}
		return undefined;
	}
	
	function _deleteResponse(serviceName) {
		localStorage.removeItem('offlineRes_' + serviceName);
	}
	
	function _deleteAllResponses() {
		Object.keys(localStorage).forEach(function(key) {
	        if (/^offlineRes_/.test(key)) {
	            localStorage.removeItem(key);
	        }
	    });
	}
	
	///////////////////////////////////
    /// API ///////////////////////////
    ///////////////////////////////////
	
	return {
		isSupported:			_isSupported,
		
		onOfflineRequest:		_onOfflineRequest,
		
		storeResponse:			_storeResponse,
		loadResponse:			_loadResponse,
		deleteResponse:			_deleteResponse,
		deleteAllResponses:		_deleteAllResponses
	};
}();

var Page = function() {
	
	///////////////////////////////////
    /// Getters ///////////////////////
    ///////////////////////////////////
	
	function parseQueryString(query) {
		var $ = {};
	    var vars = query.split('&');
	    for (var i = 0; i < vars.length; i++) {
	        var pair = vars[i].split('=');
	        $[decodeURIComponent(pair[0])] = decodeURIComponent(pair[1]);
	    }
	    return $;
	}
	
	function _parseQuery() {
		var url = window.location.search;
	    var start = url.indexOf("?");
	    return start !== -1 ? parseQueryString(url.substring(start + 1)) : {};
	}
	
	function _parseHash() {
		var hash = window.location.hash;
		hash = hash.substring(hash.lastIndexOf('#') + 1);
		return  hash.length > 0 ? parseQueryString(hash) : {};
	}
	
	function _getFragment(url) {
		url = (url !== undefined ? url : window.location.hash);
		url = url.substring(url.lastIndexOf('#') + 1);
		if (url.indexOf('&') !== -1) {
			url = url.substring(0, url.indexOf('&'));
		}
		return url;
	}
	
	function _getCurrentPage() {
		return 	App.isSPA() ?
				(_getFragment().length > 0 ? Page.appendDotHtml(_getFragment()) : spa_entryFragment)  :
				window.location.href.substr(window.location.href.lastIndexOf('/') + 1).split('?')[0];
	}
	
	function _getLoginPage() {
		return 	typeof app !== 'undefined' && app.loginPage != undefined && app.loginPage != null ?
				app.loginPage.trim() :
				'';
	}
	
	///////////////////////////////////
    /// Navigate / Manipulate /////////
    ///////////////////////////////////
	
	function _appendDotHtml(name) {
		name = _getFragment(name);
		return !/\.html$/.test(name) && name.indexOf('/') === -1 ? name + '.html' : name;		//target.endsWith(".html")
	}
	
	function setHash(target) {
		window.location.hash = '#' + target.replace(/^#/, "").replace(/.html$/, "");
	}
	
	function _navigate(target) {
		target = Page.appendDotHtml(target);
	    
	    var loginPage = this.getLoginPage();
		if (this.getCurrentPage() === loginPage) {
			sessionStorage.setItem('_is_logged_in', target !== undefined && target !== loginPage);
		}
		
		if (App.isSPA() && target !== 'index.html') {
			if (Page.appendDotHtml(_getFragment()) !== target) {
				setHash(target);
				return;
			}
		} else {
			saveUserData();
			window.location = target;
		}
	}
	
	function _validateLogin() {
		var isLoggedIn = sessionStorage.getItem('_is_logged_in') === 'true';
		var loginPage = this.getLoginPage();
		if (this.getCurrentPage() === loginPage || this.getCurrentPage().indexOf("theme_editor") != -1) {
			sessionStorage.setItem('_is_logged_in', false);
			return;
		}
		if (!isLoggedIn && loginPage !== '') {
			Page.navigate(loginPage);
		}
	}
	
	///////////////////////////////////
    /// API ///////////////////////////
    ///////////////////////////////////
	
	return {
		appendDotHtml: 		_appendDotHtml,
		
		navigate: 			_navigate,
		
		parseQuery: 		_parseQuery,
		parseHash: 			_parseHash,
		
		getCurrentPage: 	_getCurrentPage,
		getLoginPage: 		_getLoginPage,
		getFragment:		_getFragment,
		
		validateLogin: 		_validateLogin
	};
}();

//backward compatibility
Page.parseQueryParams = Page.parseQuery;

var Popup = function() {
	
	///////////////////////////////////
    /// Buttons ///////////////////////
    ///////////////////////////////////
	
	var _okCallback = undefined;
	var _cancelCallback = undefined;

	function onButtonClick(id, callback) {
		if (!$('#' + id)[0].hasAttribute('data-rel')) {	// old versions already close the popup via data-rel="close"
			$("#popupContainer").popup("close");
		}
        if (callback != undefined) {
        	var timer = setInterval(function() {	// wait for popup to close before calling callback
    		   if ($('#popupContainer-screen')[0].className.indexOf('ui-screen-hidden') !== -1) {
    			   callback();
    		       clearInterval(timer);
    		   }
    		}, 10);
        }
	}
	
	$(window).on('load', function() {
		$('#popupOkButton').on('click', function () {
			onButtonClick('popupOkButton', _okCallback);
		});
		$('#popupCancelButton').on('click', function () {
			onButtonClick('popupCancelButton', _cancelCallback);
		});
	});
	
	///////////////////////////////////
    /// Common ////////////////////////
    ///////////////////////////////////
	
	function _injectVars(message) {
		if (message === undefined || message === null) {
			return message;
		}
		var regex = /\${(.*?)}/g;
		return ('' + message).replace(regex, function(match, group) {
			return Storage.get(group);
		});
	}

	function _showPopupCommon(title, message) {
		$("#popupTitle").text(_injectVars(title));
	    $("#popupMessage").html(_injectVars(message));
	    
	    setTimeout(function() {
	    	$("#popupContainer").popup({history: false});
	    	$("#popupContainer").popup("open");
	    }, 200);
	}
	
	///////////////////////////////////
    /// By type ///////////////////////
    ///////////////////////////////////
	
	function _ok(title, message, okCallback) {
		$('#popupOkButton').text('OK');
		$("#popupCancelButton").hide();
		_okCallback = okCallback;
		
		_showPopupCommon(title, message);
	}
	
	function _okCancel(title, message, okCallback, cancelCallback) {
		$('#popupOkButton').text('OK');
		$('#popupCancelButton').text('Cancel');
		$("#popupCancelButton").show();
		
		_okCallback = okCallback;
		_cancelCallback = cancelCallback;
		
		_showPopupCommon(title, message);
	}
	
	function _custom(title, message, button1Label, button2Label, button1Callback, button2Callback) {
		$('#popupOkButton').text(button1Label);
		if (button2Label !== undefined) {
			$('#popupCancelButton').text(button2Label);
			$("#popupCancelButton").show();
		} else {
			$("#popupCancelButton").hide();
		}
		
		_okCallback = button1Callback;
		_cancelCallback = button2Callback;
		
		_showPopupCommon(title, message);
	}
	
	function _serviceErrors(serviceError, status) {
	    var errorAlert = "<div> Service failed with errors [status " + status + "]:<br />&#9658;";
	    
	    errorAlert += [].concat.apply([], serviceError.split("'").map(function(v,i){
	        return i % 2 ? "'" + v + "'" : v.split(';').join("<br />&#9658;")
		})).filter(Boolean).join("");

	    errorAlert += "<div/>";
	    this.info('Error', errorAlert);
	}
	
	///////////////////////////////////
    /// API ///////////////////////////
    ///////////////////////////////////
	
	return {
		ok: 				_ok,
		okCancel: 			_okCancel,
		custom: 			_custom,
		serviceErrors: 		_serviceErrors
	};
}();

Popup.info = Popup.ok;
Popup.confirm = Popup.okCancel;

var Services = function() {
	
	var arrayOutputs = {};	// maps {serviceName} --> {outputParamKey[]}
	
	///////////////////////////////////
    /// Init //////////////////////////
    ///////////////////////////////////
	
	/**
	 * Declare the names of service's output parameters, so the code will know to clear them even when empty array is returned.
	 */
	function _registerArray(serviceName, outputParams) {
		arrayOutputs[serviceName] = outputParams;
	}
	
	/**
	 * Required for Okta & Azure, not for IDCS.
	 */
	function _initOAuth2(hashKey) {
		var hash = Page.parseHash();
		var loginPage = Page.getLoginPage();
		if (loginPage === '') {
			throw 'LoginPage not set! You must declare login page in AppVisualizerStep1 to use OAuth2';
		}
		if (hash[hashKey] !== undefined) {
			Services.setHeader('Authorization', 'Bearer ' + hash[hashKey]);
		} else if (Page.getCurrentPage() !== loginPage && !Storage.contains('_header_Authorization')) {
			Page.navigate(loginPage);
			throw 'OAuth2: not authorized';
		}
	}
	
	///////////////////////////////////
    /// Before service call ///////////
    ///////////////////////////////////
	
	function _setHeader(key, value) {
		if (value !== undefined) {
			Storage.set('_header_' + key, value);
		} else {
			Storage.remove('_header_' + key, value);
		}
	}
	
	function generatePartialPlaybackQueryTokens(serviceName) {
		var $ = '';
		
		if (typeof(partialPlayback) !== "undefined") {
			if (partialPlayback.keepAlive instanceof Array &&
				partialPlayback.keepAlive.indexOf(serviceName) !== -1) {
					$ += '&keepAlive=true'
			}
		}
		return $;
	}
	
	function generateMetaQueryTokens() {
		var $ = '';
		
		$ += '&meta.app=' + App.getName() + (Metadata.getTransactionId() !== undefined ? ',' + Metadata.getTransactionId() : '');
		
		return $;
	}
	
	///////////////////////////////////
    /// After service call ////////////
    ///////////////////////////////////
	
	function onWebServiceAjaxSuccess(response, successHandler, failureHandler, serviceName, populateFields, context) {
	    window.response = response;
	    var serviceErrorMsg = getResponseNodeValueByName("Error");

	    if (serviceErrorMsg.toLowerCase().indexOf("service is disabled") !== -1) {
	        showInfoPopup('Service Error', serviceErrorMsg);
	        executeResponseHandler(failureHandler, undefined, serviceName, undefined);
	        $(document).triggerHandler("receiveResponse", [null, serviceName, "error", populateFields]);

	    } else if (typeof serviceErrorMsg !== 'undefined' && serviceErrorMsg !== null && serviceErrorMsg !== '') {
	        failureHandler = populateErrorsToHandler(failureHandler, serviceErrorMsg, 200);
	        analyzeJson(response, failureHandler, serviceName, populateFields, context);
	        $(document).triggerHandler("receiveResponse", [null, serviceName, "error", populateFields]);
	    } else {
	        analyzeJson(response, successHandler, serviceName, populateFields, context);
	        $(document).triggerHandler("receiveResponse", [response, serviceName, "success", populateFields]);
	    }
	}
	
	function onWebServiceAjaxFailure(response, status, failureHandler, serviceName, populateFields, context) {
	    var serviceErrorMsg = getResponseNodeValueByName("Error", response.responseJSON);

	    if (typeof serviceErrorMsg === 'undefined' || serviceErrorMsg == null || serviceErrorMsg === "") {
	    	if (response.status === 401) {
	    		 showInfoPopup('Service Error', 'Unauthorized or session expired');
	    	} else if (response.status === 404) {
	            showInfoPopup('Service Error', 'Service has failed with status of 404 - Requested page not found');
	        } else if (response.status === 500) {
	            showInfoPopup('Service Error', 'Service has failed with status of 500 - Internal Server Error');
	        } else if (status === 'parsererror' && !isEmpty(response.responseText) && response.responseText.indexOf('The requested URL was rejected. Please consult with your administrator.') !== -1) {
	        	showInfoPopup('F5/LoadBalancer Error', response.responseText.replace('[Go Back]', ''));
	        } else if (status === 'parsererror') {
				    showInfoPopup('Service Error', 'Response parse error');
	        } else if (status === 'timeout') {
	            showInfoPopup('Service Error', 'Timeout reached, no response');
	        } else if (status === 'abort') {
	            showInfoPopup('Service Error', 'Ajax request aborted');
	        } else {
	            showInfoPopup('Service Error', 'Unexpected Error: \n' + response.responseText);
	        }
	        
	        if (!/^popupErrors:/.test(failureHandler)) {		//!failureHandler.startsWith('popupErrors:') || !popupLaunched
	        	executeResponseHandler(failureHandler, undefined, serviceName, undefined);
	        }

	    } else if (typeof serviceErrorMsg !== 'undefined' && serviceErrorMsg != null && serviceErrorMsg !== "") {
	        failureHandler = populateErrorsToHandler(failureHandler, serviceErrorMsg, response.status);
	        analyzeJson(response.responseJSON, failureHandler, serviceName, populateFields, context);
	    }

	    $(document).triggerHandler("receiveResponse", [null, serviceName, "error", populateFields]);
	}
	
	function analyzeJson(json, responseHandler, serviceName, populateFields, context) {
	    if (typeof json["Response"] === 'undefined') {
	        executeResponseHandler(responseHandler, json, serviceName);
	        return;
	    }

	    //Extract special output parameters
	    store('Error', json["Response"][serviceName + "Message"]["Error"]);
	    store('PopupMessages', json["Response"][serviceName + "Message"]["PopupMessages"]);
	    store('StatusBarMessages', json["Response"][serviceName + "Message"]["StatusBarMessages"]);
	    
	    var sessionId = json["Response"][serviceName + "Message"]["sessionId"];
	    if (sessionId !== undefined) {
	    	store('sessionId', sessionId);
	    }
	    
	    var ticket = json["Response"][serviceName + "Elements"]["AP_TICKET"];
	    if (ticket !== undefined) {
	    	Services.setHeader("Authorization", "Basic " + btoa("ticket:" + ticket));
	    }

	    //Handle Elements
	    var elements = json['Response'][serviceName + 'Elements'];
	    if (typeof(populateFields) === "undefined" || populateFields) {
	    	for (var i in elements) {
	    		populateField(i, elements[i], "_output");
            }
        }

	    //Handle Array Items
	    var tableRows = null;
	    if (typeof json["Response"][serviceName + "TableArray"] !== 'undefined') {
	        tableRows = [].concat(json["Response"][serviceName + "TableArray"][serviceName + "ArrayItem"]);
	        if (!/^lov:/.test(context)) {	// !context.startsWith('lov:')
	        	clearArrayInStorage(serviceName, tableRows);
		    	populateArray(tableRows);
		    	if (typeof(populateFields) === "undefined" || populateFields) {
			        populateTableOrList();
			    }
	        }
	    }

	    executeResponseHandler(responseHandler, json, serviceName, tableRows);
	    return true;
	}
	
	function populateErrorsToHandler(failureHandler, message, status) {
		if (isString(failureHandler) && /^popupPopupMessages:/.test(failureHandler)) {		//failureHandler.startsWith('popupPopupMessages:')
			var popupMessages = getResponseNodeValueByName("PopupMessages");
			return 	popupMessages.length !== 0 ?
					failureHandler + popupMessages + ";" + status :
					'popupErrors:' + message + ";" + status;	// in case that PopupMessages are empty, fallback to displaying errors
		}
		
		if (isString(failureHandler) && /^popupErrors:/.test(failureHandler)) {		//failureHandler.startsWith('popupErrors:')
			return failureHandler + message + ";" + status;
		}
		
		return failureHandler;
	}
	
	function clearArrayInStorage(serviceName, array) {
		var keys = 	arrayOutputs[serviceName] !== undefined ? arrayOutputs[serviceName] :
					array.length > 0 ? Object.keys(array[0]) :		/* array check for backward compatibility */
					[];
					
		keys.forEach(function(key) {
			Storage.deleteByPrefix(key.substr(0, getNameWoIndexLength(key)) + '_');
		});
	}
	
	function populateArray(array) {		// populates to HTML to handle singular fields that are not part of a table/list
		if (array == null || !isArray(array)) {
			return;
		}
		
		for (var i = 0; i < array.length; i++) {
			var arrayRow = array[i]; 
	        if (arrayRow == undefined) {
	        	continue;
	        }

	        for (var key in arrayRow) {
	            var indexedKey = key.substr(0, getNameWoIndexLength(key)) + '_' + i;
	            populateField(indexedKey, arrayRow[key]);
	            
	            if (i === 0 && !/_0$/.test(key)) {	//!key.endsWith('_0')
	            	populateField(key, arrayRow[key]);
	            }
	        }
	    }
	}
	
	function executeResponseHandler(responseHandler, data, serviceName, tableRows) {
	    if (typeof responseHandler === 'undefined' || responseHandler === '') {
	        return;
	    }

	    //response handler is function
	    if (typeof responseHandler.indexOf === 'undefined' || responseHandler.indexOf(':') === -1) {
	        if (typeof responseHandler !== 'undefined' ||
	            (typeof window[responseHandler] !== 'undefined' && window[responseHandler] !== null)) {
	            if (typeof window[responseHandler] === 'function') {
	                window[responseHandler].call(this, data, serviceName, tableRows);
	            } else if (typeof responseHandler === 'function') {
	                responseHandler.call(this, data, serviceName, tableRows);
	            }
	        }
	        return;
	    }
	    
	    if (/^popupErrors:/.test(responseHandler)) {	//responseHandler.startsWith('popupErrors:')
	        var popupContents = responseHandler.substring(12);
	        var separatorPos = popupContents.lastIndexOf(';');
	        Popup.serviceErrors(popupContents.substring(0, separatorPos), popupContents.substring(separatorPos + 1));
	        return;
	    }
	    if (/^popupPopupMessages:/.test(responseHandler)) {	//responseHandler.startsWith('popupPopupMessages:')
	        var popupContents = responseHandler.substring(19);
	        var separatorPos = popupContents.lastIndexOf(';');
	        Popup.info('Error', popupContents.substring(0, separatorPos));
	        return;
	    }
	    if (/^popupAndNavigate:/.test(responseHandler)) {	//responseHandler.startsWith('popupAndNavigate:')
	    	var separatorPos = responseHandler.lastIndexOf(':');
	    	var popupText = responseHandler.substring(17, separatorPos);
	    	var targetPage = responseHandler.substring(separatorPos + 1);
	        Popup.info('', popupText, function() {
	    	    navigate(targetPage);
	    	});
	        return;
	    }
	    if (/^popup:/.test(responseHandler)) {	//responseHandler.startsWith('popup:')
	        var popupText = responseHandler.substring(6);
	        Popup.info('', popupText);
	        return;
	    }
	    if (/^navigate:/.test(responseHandler)) {	//responseHandler.startsWith('navigate:')
	        var targetPage = responseHandler.substring(9);
	        navigate(targetPage);
	        return;
	    }
	}
	
	///////////////////////////////////
    /// Calls /////////////////////////
    ///////////////////////////////////
	
	function _call(serviceName, successFunction, failureFunction, customInput) {
		failureFunction = transformFailureHandler(failureFunction);
		this.callWebServiceWithAllParams(serviceName, undefined, successFunction, failureFunction, true, true, customInput);
	}
	
	function _callSync(serviceName, failureFunction, customInput) {
		function successFunction(_response) {
			response = _response;
		}
		
		var response;
		this.callWebServiceWithAllParams(serviceName, undefined, successFunction, failureFunction, false, true, customInput);
		return response;
	}
	
	function _callExternal(httpMethod, url, input, headers) {
		if (waitingForResponse) {
			return;
		}
		Spinner.start();
		waitingForResponse = true;
		var _response;
		
		$.ajax({
	        url: url,
	        headers: headers,
	        type: httpMethod,
	        contentType: "application/json;charset=utf-8",
	        dataType: "json", 	// expected response format
	        timeout: Services.getTimeout(),
	        data: JSON.stringify(input),
	        async: false,
	        success: function (response, textStatus, xhr) {
	        	waitingForResponse = false;
	        	Spinner.stop();
	        	_response = response;
	        },
	        error: function (response, status, error) {
	        	waitingForResponse = false;
	        	Spinner.stop();
	        	throw response;
	        }
	    });
		return _response;
	}
	
	///////////////////////////////////
    /// Lagacy calls //////////////////
    ///////////////////////////////////
	
	/**
	 *
	 * @param webService -     name of webservice
	 * @param params -         query string
	 * @param initHandler -    function to be run before call to webservice,
	 *                         return false to abort execution.
	 *                         initHandler(serviceName)
	 * @param asyncFlag -      call web service asynchronously
	 * @param populateFields - field populator callback
	 * @param failureHandler - function to be run after webservice call in case of a failure
	 * @param responseHandler - function to be run after webservice call,
	 *                            responseHandler(response, serviceName, status)
	 *            response - in json format.
	 *            serviceName - string
	 *            status - one of: "success","notfound","internal","parsererror","timeout","abort","unknown"
	 *
	 */
	function _callWebService(webService, params, initHandler, responseHandler, failureHandler, asyncFlag, populateFields, context) {
		if (waitingForResponse) {	//prevent calls to webservice while waiting for response
	        return;
	    }

	    webService = webService.trim();
	    if (typeof webService === 'undefined' || webService === '') {
	        return;
	    }
	    
	    var webServiceUrl;
	    if (webService.indexOf("/") === -1 && webService.indexOf(".") === -1 && webService.indexOf(":") === -1) {
	        webServiceUrl = "/ServiceManager/Macro/ExecMacro/" + webService;	//if webService is not URL, assume it is local service
	    } else {
	        webServiceUrl = webService;		//webService is assumed to be URL
	    }
	    
	    var serviceName = webServiceUrl.substr(webServiceUrl.lastIndexOf('/') + 1);

	    var queryData = (params? params+'&': '') + 'randomSeed=' + (Math.random() * 1000000) + '&json=true';
	    queryData += generatePartialPlaybackQueryTokens(serviceName);
	    queryData += generateMetaQueryTokens();
	    
	    //call init handler
	    if (typeof initHandler !== 'undefined') {
	        //get the function by calling window[errorHandler]
	        if (typeof window[initHandler] !== 'undefined' && window[initHandler] !== null) {
	            if (typeof(window[initHandler]) === 'function')
	                var initResult = window[initHandler].call(this, serviceName);
	            if (initResult === false) {
	                return; //abort execution
	            }
	        }
	    }
	    
	    if (!/^lov:/.test(context)) {	// !context.startsWith('lov:')
	    	Spinner.start();
	    	$(document).triggerHandler("sendRequest");
	    }

	    var response = Offline.loadResponse(serviceName);
	    if (response !== undefined) {
	    	onWebServiceAjaxSuccess(response, responseHandler, failureHandler, serviceName, populateFields, context);
	    } else {
	    	sendServiceRequest(serviceName, getServiceManagerHost() + webServiceUrl, queryData, asyncFlag, responseHandler, failureHandler, populateFields, context);
	    }
	}
	
	/**
	 *
	 * @param webService -    name of webservice
	 * @param initHandler - function to be run before call to webservice,
	 *                        return false to abort execution.
	 *                        initHandler(serviceName)
	 *
	 * @param responseHandler - function to be run after webservice call,
	 *                            responseHandler(response, serviceName, status)
	 *            response - in json format
	 *            serviceName - string
	 *            status - one of: "success","notfound","internal","parsererror","timeout","abort","unknown"
	 *
	 */
	function _callWebServiceWithAllParams(webService, initHandler, responseHandler, failureHandler, asyncFlag, populateFields, customInput) {
		var that = this;
		var callServiceWithParams = function() {
			if (isObject(customInput)) {
				var params =  jQuery.param(customInput);
				that.callWebService(webService, params, initHandler, responseHandler, failureHandler, asyncFlag, populateFields);
			} else {
				if (asyncFlag) {
					getInputFieldsAsQueryString(webService, true).then(function(params) {
						that.callWebService(webService, params, initHandler, responseHandler, failureHandler, asyncFlag, populateFields);
					});
				} else {
					that.callWebService(webService, getInputFieldsAsQueryString(webService, false), initHandler, responseHandler, failureHandler, asyncFlag, populateFields);
				}
			}
	    };
	    
	    if (asyncFlag) {
	    	Files.uploadNewFiles().then(callServiceWithParams);
	    } else {
	    	Files.uploadNewFiles(true);
	    	callServiceWithParams();
	    }
	}
	
	
	///////////////////////////////////
    /// Service HTTP request //////////
    ///////////////////////////////////
	
	function _getTimeout() {
		return typeof app !== 'undefined' && !isNaN(app.serviceCallTimeout) ? +app.serviceCallTimeout : 60 * 1000;
	}
	
	function transformFailureHandler(failureHandler) {
		return (failureHandler === undefined ? 'popupErrors:' :
			    failureHandler === null ? undefined :
			    failureHandler);
	}

	function _recordMock(serviceName, response, responseHandler, failureHandler, serviceName, populateFields, context) {
		var origResponse = response;
		$.ajax({
	        url: getServiceManagerHost() + "/ServiceManager/Macro/ServiceMock/" + serviceName,
	        type: "POST",
	        timeout: Services.getTimeout(),
	        headers: {
	        	"AP-No-Challenge": true,
	        	"Content-Type": "application/json;charset=UTF-8"
	        },
	        dataType: "json", // expected format for response
	        data: JSON.stringify(response),
	        async: false,
	        success: function (response) {
	        	Spinner.stop();
	        	onWebServiceAjaxSuccess(origResponse, responseHandler, failureHandler, serviceName, populateFields, context);
	        }
	    });
	}

	function sendServiceRequest(serviceName, url, queryData, asyncFlag, responseHandler, failureHandler, populateFields, context) {
		waitingForResponse = true;
		$.ajax({
	        url: url,
	        headers: generateHeaders(),
	        type: "POST",
	        timeout: Services.getTimeout(),
	        dataType: "json", // expected format for response
	        data: queryData,
	        async: typeof asyncFlag === 'undefined' ? true : asyncFlag,
	        success: function (response, textStatus, xhr) {
	        	Offline.storeResponse(serviceName, response);
	        	waitingForResponse = false;
	        	if (Storage.get("recordMock").toLowerCase() === 'true') {
	        		_recordMock(serviceName, response, responseHandler, failureHandler, serviceName, populateFields, context);
	        	} else {
		        	Spinner.stop();
		            onWebServiceAjaxSuccess(response, responseHandler, failureHandler, serviceName, populateFields, context);
	        	}
	        },
	        error: function (response, status, error) {
	        	waitingForResponse = false;
	        	Spinner.stop();
	        	if (response.status === 0 && !(status === 'timeout' && error === 'timeout')) {
	        		// offline status would usually be status==='error' && error='', but maybe there are more cases
	        		// status==='error' && error='' means ajax request timeout (reached Services.getTimeout())
	        		Offline.onOfflineRequest(serviceName, url, queryData);
	        	} else {
	        		onWebServiceAjaxFailure(response, status, failureHandler, serviceName, populateFields);
	        	}
	        }
	    });
	}
	
	///////////////////////////////////
    /// Sessions (Partial playback) ///
    ///////////////////////////////////
	
	function _startSession() {
		store('keepAlive', true);
	}

	function _endSession() {
		store('keepAlive', false);
	}
	
	function _killSession(sessionId) {
		var sessionId = typeof(sessionId) !== "undefined" ?
						sessionId :
						sessionStorage.getItem('sessionId');
		if (sessionId === undefined || sessionId === null) {
			return;
		}
		
	    Spinner.start();
	    $.ajax({
	        url: getServiceManagerHost() + "/ServiceManager/Macro/Sessions/" + sessionId,
	        type: "DELETE",
	        timeout: Services.getTimeout(),
	        dataType: "json", // expected format for response
	        async: false,
	        success: function (response) {
	        	if (sessionStorage.getItem('sessionId') === sessionId) {
	        		sessionStorage.removeItem('sessionId');
	        		store('keepAlive', false);
	        	}
	        	Spinner.stop();
	        },
	        error: function (response, status, error) {
	        	Spinner.stop();
	        }
	    });
	}
	
	///////////////////////////////////
    /// API ///////////////////////////
    ///////////////////////////////////
	
	return {
		registerArray: 					_registerArray,
		getTimeout: 					_getTimeout,
		setHeader: 						_setHeader,
		
		call: 							_call,
		callSync: 						_callSync,
		callExternal:					_callExternal,
		
		callWebService: 				_callWebService,
		callWebServiceWithAllParams: 	_callWebServiceWithAllParams,
		
		initOAuth2:						_initOAuth2,
		
		startSession: 					_startSession,
		endSession: 					_endSession,
		killSession: 					_killSession
	};
}();

var Spinner = function() {

	function _init() {
		if ($('#spinner').length === 0) {
			$('body').prepend('<div id="spinner-background"></div><div id="spinner"></div>');
		}
	}

	
	///////////////////////////////////
    /// Full screen spinner ///////////
    ///////////////////////////////////
	
	function _start() {
		if (document.getElementById("spinner") !== null) {
			document.getElementById("spinner").style.display = 'block';
			document.getElementById("spinner-background").style.display = 'block';
		}
	
	}
	
	function _stop() {
		if (document.getElementById("spinner") !== null) {
			document.getElementById("spinner").style.display = 'none';
			document.getElementById("spinner-background").style.display = 'none';
		}
    }
	
	///////////////////////////////////
    /// Top-right corner spinner //////
    ///////////////////////////////////
	
	function _startMiniSpinner(text) {
    	$(document.body).append(
			'<div id="small-spinner" class="ui-loader ui-corner-all ui-body-z ui-loader-verbose small-spinner">' +
		   		'<span class="ui-icon-loading"><h1>' + text + '</h1></span>' + 
		   	'</div>');
    }
    
    function _stopMiniSpinner() {
    	var spinner = document.getElementById('small-spinner');
    	if (spinner != undefined) {
    		spinner.parentNode.removeChild(spinner);
    	}
    }
	
	///////////////////////////////////
    /// API ///////////////////////////
    ///////////////////////////////////
	
	return {
		init:				_init,
		
		start: 				_start,
		stop: 				_stop,
		
        startMiniSpinner: 	_startMiniSpinner,
        stopMiniSpinner: 	_stopMiniSpinner
	};
}();

var Storage = function() {
		
	return {
		
		clear: function() {
			// TODO Warning! may clear auraplayer's inner flags - related to Login Page, Table Source, and more..
			Object.keys(sessionStorage).forEach(function(key) {
				if (key.indexOf("_metadata") == -1) {
					sessionStorage.removeItem(key);
				}
			});
		},
		
		clearBackups: function() {
			this.clearByPrefix('_backup_');
		},
		
		contains: function(key) {
			return sessionStorage.getItem(key) !== null;
		},
		
		copyFromIndex: function(key, index) {
			var value = this.getFromIndex(key, index);
			this.set(key, value);
		},
		
		count: function(key) {
			var count = 0;
			var nameWoIndex = key.substr(0, getNameWoIndexLength(key)) + '_';
			Object.keys(sessionStorage).forEach(function(key) {
				if (key.indexOf(nameWoIndex) === 0 && !isNaN(key.substr(nameWoIndex.length))) {
					count++;
				}
			});
			return count;
		},
		
		backup: function(key) {
			var originalValue = sessionStorage.getItem(key);
			if (originalValue !== null) {
				store('_backup_' + key, originalValue);
			}
		},
		
		backupAndCopyFromIndex: function(key, index) {
			this.backup(key);
			this.copyFromIndex(key, index);
		},
		
		backupAndSet: function(key, value) {
			backupField(key);
			this.set(key, value);
		},
		
		deleteByPrefix: function(prefix) {
			var regex = new RegExp("^" + prefix);
			Object.keys(sessionStorage).forEach(function(key) {
				if (regex.test(key)) {
					sessionStorage.removeItem(key);
				}
			});
		},
		
		deleteAllIndices: function(paramName) {
			var nameWoIndex = paramName.substr(0, getNameWoIndexLength(paramName)) + '_';
			Object.keys(sessionStorage).forEach(function(key) {
				if (key.indexOf(nameWoIndex) === 0 && !isNaN(key.substr(nameWoIndex.length))) {
					sessionStorage.removeItem(key);
				}
			});
		},
		
		deleteBySubstring: function(substr) {
			Object.keys(sessionStorage).forEach(function(key) {
		        if (key.indexOf(substr) >= 0) {
		            sessionStorage.removeItem(key);
		        }
		    });
		},
		
		get: function(key) {
			var value = "";
		    try {
		        value = sessionStorage.getItem(key);
		    } catch (e) {}

		    return cleanValue(value);
		},
		
		getArray: function(key) {
			var array = [];
			var prefix = getNameWoIndex(key) + '_';
			var current;
			for (var i = 0; (current = sessionStorage.getItem(prefix + i)) !== null; i++) {
				array.push(current);
			}
			return array;
		},
		
		getFromIndex: function(key, index) {
			var indexedKey = key.substr(0, getNameWoIndexLength(key)) + '_' + index;
			return this.get(indexedKey);
		},
		
		set: function(key, value) {
			sessionStorage.setItem(key, value);
		},
		
		restoreBackups: function(doPopulate) {
			Object.keys(sessionStorage).forEach(function(key) {
				if (/^_backup_/.test(key)) {
					sessionStorage.setItem(key.substr(8), sessionStorage.getItem(key));
					sessionStorage.removeItem(key);
				}
			});
			if (doPopulate) {
				Table.populate();
				List.populate();
			}
		},
		
		remove: function(key) {
			sessionStorage.removeItem(key);
		}
	};
}();

// backward compatibility
Storage.removeBySubstring = Storage.deleteBySubstring;
Storage.clearByPrefix = Storage.deleteByPrefix;
Storage.clearAllIndices = Storage.deleteAllIndices;

/****************************
 *** Common *****************
 ****************************/

/**
 * Get the highest index existing for a parameter 
 * @param fieldName
 */
function getTableOrListStart(headElementId) {
	var head = document.getElementById(headElementId);
	if (head == null) {
		return 0;
	}
	var startIndex = head.getAttribute('start-index');
	return startIndex != null ? startIndex : 0;
}

function getHighestIndex(fieldName) {
	var $ = -1;
	var fieldNameWoIndex = fieldName.substr(0, getNameWoIndexLength(fieldName));
	
	for (var key in sessionStorage) {
        var keyWoIndex = key.substr(0, getNameWoIndexLength(key));
        
		if (keyWoIndex === fieldNameWoIndex) {
			var index = +key.substr(key.lastIndexOf('_') + 1);
			if (index > $) {
				$ = index;
			}
		}
	}
	return $;
} 

function getTableOrListEnd(columnsMetadata) {
	if (tableSource.type === 'array') {
		return tableSource.data.length - 1;
	}
	var lastIndex = -1;
	for (var i = 0; lastIndex === -1 && i < columnsMetadata.length; i++) {
		lastIndex = getHighestIndex(columnsMetadata[i].id);
	}
	return lastIndex;
}

function executeTableOnClickHandlers(row, col, rowCells) {
	var onTableClickHandlers = [];
    $.merge(onTableClickHandlers, getHandlersByFilter(handlerMap, {"action": "tableClick:webservice"}));
    $.merge(onTableClickHandlers, getHandlersByFilter(handlerMap, {"action": "tableClick:navigate"}));
    $.merge(onTableClickHandlers, getHandlersByFilter(handlerMap, {"action": "tableClick:function"}));
    for (var i = 0; i < onTableClickHandlers.length; i++) {
        executeHandler(onTableClickHandlers[i], row, col, rowCells);
    }
}

function formatTableValue(displayFormat, value) {
	return  !!displayFormat && displayFormat.indexOf('%s') !== -1 ?
			displayFormat.replace('%s', value):
			value;
}

/****************************
 *** table-list selectors ***
 ****************************/

var hasTable, hasList;
var tableOutputBody, listOutput;
var tableSource = Storage;

function selectSource() {
	var key = '_table_' + Page.getCurrentPage();
	var source = Storage.get(key);
	
	if (source === undefined || source === '') {
		tableSource = Storage;
		return;
	}
	
	if (source.indexOf('[') !== -1) {
		tableSource = {
			type: 'array',
			data: JSON.parse(source),
			get: function(indexedCellName, baseCellName, rowIndex) {
				return  rowIndex < this.data.length ?
						this.data[rowIndex][baseCellName] :
						'';
			}
		};
		console.log(key + ' source set to Array');
		return;
	}
	
	var funcName = JSON.parse(source);
	var func = window[funcName];
	if (isFunction(func)) {
		tableSource = {
			type: 'function',
			get: function(indexedCellName, baseCellName, rowIndex) {
				return func(indexedCellName, baseCellName, rowIndex);
			}
		};
		console.log(key + ' source set to Function ' + funcName);
		return;
	}
	
	tableSource = Storage;
	console.warn(key + ' source invalid, defaulting to SessionStorage');
}

function populateTableOrList(isInit) {
	selectSource();
	
	if (hasTable) {
		Table.populate(tableOutputBody, isInit);
	} else if (hasList) {
		List.populate(listOutput, isInit);
	}
}

/****************************
 *** onLoad *****************
 ****************************/

function initTableOrList() {
	tableOutputBody = document.getElementById("tableOutputBody");
	listOutput = document.getElementById("listOutput");
	
	hasTable = (tableOutputBody != null);
	hasList = (listOutput != null);
	
	if (hasTable) {
		Table.init();
	} else if (hasList) {
		List.init();
	}
}

var List = function() {
	
	///////////////////////////////////
    /// Init / Click listener /////////
    ///////////////////////////////////
	
	function calculateIndexInParent(element){
	    var i = 0;
	    while ((element = element.previousElementSibling) != null) {
	    	i++;
	    }
	    return i;
	}

	function addClickListener() {
		$('#listOutput').on('click','li', function(e){
			var row = calculateIndexInParent(e.currentTarget) - 1;	//first row is the table header
			var col = 0;	//list doesn't have meaning to columns. 
			
			var rowCells = [];
			var domCells = e.currentTarget.children[0].children[0].children;
			for (var i = 0; i < domCells.length; i++) {
				rowCells.push(domCells[i].innerText);
			}
			
			executeTableOnClickHandlers(row, col, rowCells);
		});
	}
	
	function _init() {
		addClickListener();
	}
	
	///////////////////////////////////
    /// Clear /////////////////////////
    ///////////////////////////////////
	
	function _clear() {
		if (listOutput == null) {
			return;
		}
		
		var numOfDataChildren = listOutput.childElementCount - 1;
		for (var i = 0; i < numOfDataChildren; i++) {
			listOutput.removeChild(listOutput.lastElementChild);
		}
	}
	
	///////////////////////////////////
    /// Populate //////////////////////
    ///////////////////////////////////
	
	/**
	 * Get array of the field IDs serving as columns.
	 */
	function getColumnsMetadata() {
		var listOutputHead = document.getElementById("listOutputHead");
		if (listOutputHead == null) {
			return null;
		}
		
		var $ = [];
		var columnElements = listOutputHead.getElementsByTagName('div');
		for(var i = 0; i < columnElements.length; i++) {
			$.push({id: columnElements[i].id, displayFormat: columnElements[i].getAttribute('display-format')});
		}
		return $;
	}
	
	/**
	 * Insert a new row to list, and populate it with values from local storage.
	 * The fields index will be the row index.
	 * Meaning, when populating parameter S_CUSTOMER_ID_0 for row number 4, the value
	 * will be evaluated as sessionStorage[S_CUSTOMER_ID_4]. 
	 * @param rowIndex number of row in table.
	 */
	function populateRow(listOutput, columnsMetadata, rowIndex) {
		var rowColumnValues = "";
		
		for (var i in columnsMetadata) {
	    	var cellName = columnsMetadata[i].id;
	    	var cellNameWithIdx = cellName.substr(0, getNameWoIndexLength(cellName)) + '_' + rowIndex;
	    	var cellValue = formatTableValue(columnsMetadata[i].displayFormat, tableSource.get(cellNameWithIdx, cellName, rowIndex));
	    	
	    	var alphabeticalIndex = String.fromCharCode("a".charCodeAt(0) + (+i % 2));
	    	rowColumnValues += 
	    		"<div" + (+i >= 2 ? " style=\"font-weight:normal\"" : "") + " class=\"ui-block-" + alphabeticalIndex +"\">\n" + 
	    		"	" + cellValue + "&nbsp;\n" +
	    		"</div>\n";		// &nbsp; required so empty values will take space
		}
		
		var liClass = columnsMetadata.length == 1 ? "ui-grid-solo" : "ui-grid-a";
		listOutput.innerHTML += 
			"<li><a href=\"#\" class=\"ui-btn ui-btn-icon-right ui-icon-carat-r\">\n" +
			"	<div class=\"" + liClass + "\">\n" +
			"		" + rowColumnValues +
			"	\n</div>\n" +
			"</a></li>";
	}
	
	/**
	 * Insert rows to list according to sessionStorage.
	 */
	function _populate(listOutput, isInit) {
		listOutput = listOutput || document.getElementById("listOutput");
		if (listOutput == null) {
			return;
		}
		
		if (!isInit) {
			document.getElementById("listOutput").style.display = 'block';
		}
		
		var columnsMetadata = getColumnsMetadata();
		if (columnsMetadata == null) {
			return;
		}
		
		List.clear();
		
		var firstIndex = getTableOrListStart('listOutputHead');
		var lastIndex = getTableOrListEnd(columnsMetadata);
		for (var i = firstIndex; i <= lastIndex; i++) {
			populateRow(listOutput, columnsMetadata, i);
		}
		
		Events.tablePopulated();
	}
	
	///////////////////////////////////
    /// API ///////////////////////////
    ///////////////////////////////////
	
	return {
		clear: 			_clear,
		init: 			_init,
		populate: 		_populate
	};
}();

var Table = function() {
	var actionCellIndex = 0;
	
	///////////////////////////////////
    /// Init / Click listener /////////
    ///////////////////////////////////
	
	function addClickListener() {
		$('#table_add_button').on('click', function(e) {
			Table.newRow();
		});
	}
	
	function _init() {
		columnsMetadata = getColumnsMetadata();
		initFilter();
		addClickListener();
	}
	
	///////////////////////////////////
    /// Filter ////////////////////////
    ///////////////////////////////////
	
	function filterTable(event) {
		var trs = document.getElementById("tableOutputBody").getElementsByTagName("tr");
		for (var i = 0; i < trs.length; i++) {
			var isMatch = false;
			var tds = trs[i].childNodes;
			for (var j = 0; j < tds.length; j++) {
				if (tds[j].innerText.toUpperCase().indexOf(event.currentTarget.value.toUpperCase()) !== -1) {
					isMatch = true;
					break;
				}
			}
			trs[i].style.display = isMatch ? "" : "none";
		}
	}
	
	function initFilter() {
		$('#tableFilter').change(filterTable);
		$('#tableFilter').on('input', filterTable);
	}
	
	///////////////////////////////////
    /// DataTables ////////////////////
    ///////////////////////////////////
	
	function configureDataTableColumns() {
		var columns = [];
		for (var i in columnsMetadata) {
	    	columns.push({orderable: (columnsMetadata[i].sortable === "true")});
		}
		return columns;
	}
 	
	function initDataTable(numOfRows) {
		if (numOfRows === 0) {
			return;
		}
		
		var config = {
			columns: configureDataTableColumns(),
			fixedHeader: {
		        header: false,
		        footer: false
			},
			destroy: true,
		    info: false,
		    ordering: true,
		    order: [],
            paging: false,
            responsive: document.getElementById("tableOutputHead").getAttribute('responsive') === 'true',
            searching: false
        }
		
		config = Events.tableConfigure(config) || config;
		
		var table =  $("#tableOutput").DataTable(config);
		handleResponsiveTableCellsDisplay(table);
		initTableCellEvents();
	}
	
	function handleResponsiveTableCellsDisplay(table) {
		table.on( 'responsive-display', function ( e, datatable, row, showHide, update ) {
		    if (showHide) {
		    	var elements = $("#"+ row.id()).find("td").filter(function() { return $(this).css("display") == "none" });
		    	if (elements.length > 0) {
		    		$("#"+ row.id()).next(".child").find("li").each(function(index, value) {
			    		var that = $(this);
			    		$(that).find(".dtr-data").empty();
			    		$(that).find(".dtr-data").append($(elements[index]));
			    		$(that).find(".tableOutputCell").css("display","table-cell");
			    		$(that).find(".tableOutputCell").css("border","none");
			    	});
		    	}
		    }
		} );
	}
	
	function handleResponsiveTableCellsHide(cellClicked) {
		var that = cellClicked;
		$(cellClicked).parent().next(".child").find("li").each(function(index, value) {
			$(that).parent().append($($(this).find(".dtr-data").children()[0]).css("display","none"));
		});
	}
	
	function initTableCellEvents() {
		$("#tableOutput tbody td").on('click', function (e) {
			if (document.getElementById("tableOutputHead").getAttribute('responsive') === 'true') {
				if ($("#mainPage").hasClass("RTL")) {
					if (($(this).closest("tr").innerWidth() - (e.pageX - $(this).closest("tr").offset().left)) > 30) {
						setTableCellClickHandlers(e);
					 } else {
						 handleResponsiveTableCellsHide(this);
					 }
				} else if (e.pageX - $(this).closest("tr").offset().left > 30) {
					setTableCellClickHandlers(e);
				} else {
					 handleResponsiveTableCellsHide(this);
				}
				
			} else {
				setTableCellClickHandlers(e);
			}
		});
	}
	
	function setTableCellClickHandlers(e) {
		if ($(e.currentTarget).find('input[type="checkbox"]').length !== 0) {
			return;		// checkbox must receive click events
		}
		
		if ($(e.currentTarget).find('input').length !== 0 ||
			$(e.currentTarget).find('.dropdown-container').length !== 0 ||
			$(e.currentTarget).closest("td").hasClass("tableActionsCell") ) {
			e.preventDefault();
			e.stopPropagation();
			return;
		}
		var row = 	e.currentTarget.parentElement.id !== undefined ?
					e.currentTarget.parentElement.id.substring(e.currentTarget.parentElement.id.lastIndexOf('_') + 1) :
					e.currentTarget.parentElement.rowIndex - 1;		//first row is the table header
		var col = 	e.currentTarget.cellIndex;
		
		var rowCells = [];
		var domCells = e.currentTarget.parentElement.cells;
		
		if (domCells) {
			for (var i = 0; i < domCells.length; i++) {
				rowCells.push(domCells[i].innerText);
			}
		}
		
		
		executeTableOnClickHandlers(row, col, rowCells);
		e.preventDefault();
		e.stopPropagation();
	}
	
	function destoryDataTable() {
		var tableElement = $("#tableOutput"); 
		if (tableElement[0].classList.contains("dataTable")) {
			tableElement.removeClass("dataTable");
			tableElement.DataTable().destroy();
		}
	}
	
	///////////////////////////////////
    /// Clear / Remove ////////////////
    ///////////////////////////////////
	
	function _clear() {
		destoryDataTable();
		
		if (tableOutputBody == null) {
			return;
		}
		
		while(tableOutputBody.rows.length > 0) {
			tableOutputBody.deleteRow(0);
		}
	}
	
	function _deleteRow(rowIndex) {
		var totalRows = Table.countRows();
		document.getElementById("tableOutputBody").deleteRow(rowIndex);

		// copy all rows after the deleted row one position to the front
		for (var currentRow = rowIndex; currentRow < totalRows - 1; currentRow++) {
			for (var i in columnsMetadata) {
		    	var cellName = columnsMetadata[i].id;
		    	var currentCellWithIdx = cellName.substr(0, getNameWoIndexLength(cellName)) + '_' + currentRow;
		    	var nextCellWithIdx = cellName.substr(0, getNameWoIndexLength(cellName)) + '_' + (currentRow + 1);
		    	Storage.set(currentCellWithIdx, Storage.get(nextCellWithIdx));
		    	$('#' + nextCellWithIdx).attr('id', currentCellWithIdx);
			}
		}
		
		// delete last row
		for (var i in columnsMetadata) {
	    	var cellName = columnsMetadata[i].id;
	    	var cellNameWithIdx = cellName.substr(0, getNameWoIndexLength(cellName)) + '_' + (totalRows - 1);
	    	Storage.remove(cellNameWithIdx);
		}
	}
	
	///////////////////////////////////
    /// Cell formatting ///////////////
    ///////////////////////////////////
	
	function generateCellHtml(cell, cellNameWithIdx, value, displayFormat, type, rowIndex, lastCell) {
		if (cellNameWithIdx.indexOf('ap_actions') === 0) {
			cell.innerHTML = '<a id="ap_remove' + cellNameWithIdx.substring('ap_actions'.length) + '"  ' +
			 				 'class="ui-btn ui-corner-all ui-shadow ui-btn-inline ui-icon-minus ui-btn-icon-notext"></a>';
			$(cell).click(function () {
				Table.deleteRow(rowIndex - 1);
			});
			$(cell).enhanceWithin();
			
		} else if (type === 'TEXT') {
			cell.innerHTML =  '<div class="ui-input-text ui-body-inherit ui-corner-all ui-shadow-inset"> <input id="' + cellNameWithIdx + '" value="' + value + '"></div>';
			$(cell).enhanceWithin();
			
		} else if (type === 'CHECKBOX') {
			var isEditable = (displayFormat === 'true');
			var isChecked = value !== undefined && (value.toUpperCase() === 'TRUE' || value.toUpperCase() === 'Y' || value.toUpperCase() === 'YES');
			if (!isEditable) {
				cellNameWithIdx = '_nostore_' + cellNameWithIdx;
			}
			cell.innerHTML = '<label for="' + cellNameWithIdx + '">&nbsp;</label>' +
							 '<input id="' + cellNameWithIdx + '" name="' + cellNameWithIdx + '" type="checkbox" style="display: none"' + 
							 (isEditable ? '' : ' disabled') + (isChecked ? ' checked' : '') + '>';
			$('#'+ cellNameWithIdx ).checkboxradio({}); 
			$(cell).enhanceWithin();
		
		} else if (type === 'LOV' || type === 'STATIC_LOV') {
			var isComboBox = (displayFormat.indexOf('isComboBox') !== -1);
			var isRTL = (displayFormat.indexOf('isRTL') !== -1);
			var isClosedSelection = (displayFormat.indexOf('isClosedSelection') !== -1);
			cell.innerHTML = isComboBox ?
							'<input  id="' + cellNameWithIdx + '" type="text" data-in-table="true" ' +
							'value="' + value + '"' + (isClosedSelection ? ' data-closed-selection ': '') + '/>' :	
								
							'<div class="ui-mini ui-icon-carat-d ui-btn-icon-' + (isRTL ? 'left' : 'right') + ' dropdown-container">' +
								'<div id="' + cellNameWithIdx + '" data-in-table="true">' + (value === '' ? '&nbsp;' : value)  + '</div>' + 
							'</div>';
			$(cell).enhanceWithin();
			
			var serviceName = displayFormat.substring(displayFormat.indexOf('|serviceName=') + 13);
			if (type === 'LOV') {
				Lov.initDynamic(cellNameWithIdx, serviceName);
			} else {
				Lov.initStatic(cellNameWithIdx);
			}
							
		} else if (type === 'ACTIONS') {
			cell.innerHTML = $(".table_actions_button_fragment").eq(actionCellIndex).html();
			cell.classList.add("tableActionsCell");
			$(cell).find(".list-button").each(function() {
				var callFunc = $(this).attr("onclick");
				var onmouseup = $(this).attr("onmouseup");
				var onmouseover = $(this).attr("onmouseover");
				var onmousedown = $(this).attr("onmousedown");
				var onmouseout = $(this).attr("onmouseout");
				$(this).on("mouseover", function() {
					this.style.color = onmouseover;
				});
				$(this).on("mouseup", function() {
					this.style.color = onmouseup;
				});
				$(this).on("mousedown", function() {
					this.style.color = onmousedown;
				});
				$(this).on("mouseout", function() {
					this.style.color = onmouseout;
				});
				$(this).click(function () {
					window[callFunc](rowIndex);
				});
				$(this)[0].removeAttribute('onclick');
				$(this)[0].removeAttribute('onmouseup');
				$(this)[0].removeAttribute('onmouseover');
				$(this)[0].removeAttribute('onmousedown');
				$(this)[0].removeAttribute('onmouseout');
				
			});
			actionCellIndex++;
			$(cell).enhanceWithin();
		} else {
			cell.innerHTML = value;
			$(cell).enhanceWithin();
		}
	}
	
	///////////////////////////////////
    /// Populate //////////////////////
    ///////////////////////////////////
	
	/**
	 * Get array of the field IDs serving as columns.
	 */
	function getColumnsMetadata() {
		var tableOutputHead = document.getElementById("tableOutputHead");
		if (tableOutputHead == null) {
			return null;
		}
		
		var $ = [];
		var tdElements = tableOutputHead.getElementsByTagName('th');
		for(var i = 0; i < tdElements.length; i++) {
			$.push({
				id: tdElements[i].id.replace("*th*",""),
				type: tdElements[i].getAttribute('data-type'),
				displayFormat: tdElements[i].getAttribute('display-format'),
				sortable: tdElements[i].getAttribute('data-sortable')
			});
		}
		return $;
	}
	
	/**
	 * Insert a new row to table, and populate it with values from local storage.
	 * The fields index will be the row index.
	 * Meaning, when populating parameter S_CUSTOMER_ID_0 for row number 4, the value
	 * will be evaluated as sessionStorage[S_CUSTOMER_ID_4]. 
	 * @param rowIndex number of row in table.
	 */
	function populateRow(tableOutputBody, columnsMetadata, rowIndex, isAddButtonRow) {
		var rowCount = tableOutputBody.rows.length;
		var row = tableOutputBody.insertRow(rowCount);
		row.id = "tablerow_" + rowIndex;
		row.classList.add("tableRow"); 
		actionCellIndex = 0;
		for (var i in columnsMetadata) {
	    	var cellName = columnsMetadata[i].id;
	    	var cellNameWithIdx = cellName.substr(0, getNameWoIndexLength(cellName)) + '_' + rowIndex;
	    	var displayFormat = columnsMetadata[i].displayFormat;
	    	var value = isAddButtonRow ? '' : tableSource.get(cellNameWithIdx, cellName, rowIndex);
	    	var formattedValue = isAddButtonRow ? value : formatTableValue(displayFormat, value);
	    	var type = columnsMetadata[i].type !== undefined && columnsMetadata[i].type !== null && columnsMetadata[i].type.length > 0 ? columnsMetadata[i].type : 'read only';
	    	
	    	var cell;
	    	if (row.cells.length == 0) {
	            cell = document.createElement('td');
	            cell.classList.add("tableOutputCell");
	            row.appendChild(cell);
	        } else {
	            cell = row.insertCell(-1);
	            cell.classList.add("tableOutputCell");
	        }
	    	
	    	generateCellHtml(cell, cellNameWithIdx, formattedValue, displayFormat, type, rowIndex , i == (columnsMetadata.length - 1) );
	    }
	}
	
	/**
	 * Insert rows to table according to sessionStorage.
	 */
	function _populate(tableOutputBody, isInit) {
		tableOutputBody = tableOutputBody || document.getElementById("tableOutputBody");
		if (tableOutputBody == null) {
			return;
		}
		
		if (!isInit) {
			document.getElementById("tableOutput").style.display = 'block';
		}
		
		Table.clear();
		
		var firstIndex = getTableOrListStart('tableOutputHead');
		var lastIndex = getTableOrListEnd(columnsMetadata);
		for (var i = firstIndex; i <= lastIndex; i++) {
			populateRow(tableOutputBody, columnsMetadata, i);
		}
		
		initDataTable(lastIndex + 1);
		
		
		Events.tablePopulated();
		
	}
	
	
	
	///////////////////////////////////
    /// Setters / Manipulators ////////
    ///////////////////////////////////
	
	function _highlightRow(rowIndex, color) {
		if (color === undefined) {
			color = '#71dc7e';
		}
		if (color === null) {
			color = rowIndex % 2 === 0 ? 'rgba(0, 0, 0, 0.05)' : 'rgba(0, 0, 0, 0)';
		}
		$('#tableOutputBody>tr:eq(' + rowIndex + ')').css('background-color', color);
	}
	
	function _newRow() {
		var tableOutputBody = document.getElementById("tableOutputBody");
		populateRow(tableOutputBody, columnsMetadata, tableOutputBody.rows.length, true);
	}
	
	function _setColumn(fieldName, value) {
		var firstIndex = getTableOrListStart('tableOutputHead');
		var lastIndex = getTableOrListEnd(columnsMetadata);
		var prefix = getNameWoIndex(fieldName) + '_';
		for (var i = firstIndex; i <= lastIndex; i++) {
			Fields.set(prefix + i, value);
		}
	}
	
	function _setSource(table, source) {
		var key = '_table_' + Page.appendDotHtml(table);
		if (source === undefined || source === null) {
			Storage.remove(key);
			return;
		}
		Storage.set(key, JSON.stringify(source));
	}
	
	function _sortBy(column, direction) {
		if (isNaN(column)) {
			var found = false;
			for (var i in columnsMetadata) {
				if (columnsMetadata[i].id === column) {
					column = i;
					break;
				}
			}
			if (isNaN(column)) {
				console.error('Column ' + column + ' not found');
				return;
			}
		}
		column = +column;
		if (direction !== 'asc' && direction !== 'desc') {
			console.warn('Invalid sort direction, defaulting to ascending order');
			direction = 'asc';
		}
		$('#tableOutput').DataTable().order([column, direction]).draw();
	}
	
	///////////////////////////////////
    /// Getters ///////////////////////
    ///////////////////////////////////
	
	function _countRows() {
		return document.getElementById("tableOutputBody").rows.length;
	}
	
	function _getColumn(fieldName) {
		var array = [];
		var prefix = getNameWoIndex(fieldName) + '_';
		var current;
		for (var i = 0; (current = Fields.get(prefix + i)) !== undefined; i++) {
			array.push(current);
		}
		return array;
	}
	
	function _toArray(filter) {
		var array = [];
		var firstIndex = getTableOrListStart('tableOutputHead');
		var lastIndex = getTableOrListEnd(columnsMetadata);
		for (var i = +firstIndex; i <= lastIndex; i++) {
			var arrayItem = {};
			arrayItem['_index'] = i;
			for (var j in columnsMetadata) {
		    	var cellName = columnsMetadata[j].id;
		    	var cellNameWoIndex = getNameWoIndex(cellName);
		    	var cellNameWithIdx = cellNameWoIndex + '_' + i;
		    	arrayItem[cellName] = Fields.get(cellNameWithIdx);
			}
			if (!isString(filter) || arrayItem[filter] === true) {
				array.push(arrayItem);
			}
		}
		return array;
	}
	
	///////////////////////////////////
    /// API ///////////////////////////
    ///////////////////////////////////
	
	return {
		clear: 					_clear,
		countRows: 				_countRows,
		deleteRow: 				_deleteRow,
		getColumn: 				_getColumn,
		
		highlightRow: 			_highlightRow,
		
		init: 					_init,
		newRow: 				_newRow,
		populate: 				_populate,
		
		setColumn: 				_setColumn,
		setSource: 				_setSource,
		sortBy: 				_sortBy,
		toArray: 				_toArray
	};
}();


function inTable(elementId) {
	return $('#' + elementId).attr('data-in-table') !== undefined;
}

var Utils = function() {
	
	return {
		split: function(text, delimiter) {
			return text.replace(new RegExp(delimiter + '+$'), "").replace(new RegExp('^' + delimiter + '+'), "").split(':');
		}
	};
}();

Utils.initOkta = function(loginPage, hashKey) {		// backward compatibility
	Services.initOAuth2(hashKey);
};

function isIE() {	// Is the app open in IE? Note: Edge will return false
	return window.document.documentMode !== undefined;
}

function isEmpty(str) {
    return (!str || 0 === str.length);
}

function isArray(o) {
    if (o == undefined) return false;
    return Object.prototype.toString.call(o) === '[object Array]';
}

function isFunction(functionToCheck) {
    var getType = {};
    return functionToCheck && getType.toString.call(functionToCheck) === '[object Function]';
}

function isString(object) {
	return Object.prototype.toString.call(object) === "[object String]";
}

function isObject(value) {
	return value !== null && typeof value === 'object';
}

function setValues(obj, key, value) {
    if (!obj) return;
    if (obj instanceof Array) {
        for (var i in obj) {
            setValues(obj[i], key, value);
        }
        return;
    }

    if (obj[key]) obj[key] = value;

    if ((typeof obj == "object") && (obj !== null)) {
        var children = Object.keys(obj);
        if (children.length > 0) {
            for (i = 0; i < children.length; i++) {
                setValues(obj[children[i]], key, value);
            }
        }
    }
}

function findValues(obj, key) {
    return findValuesHelper(obj, key, []);
}

function findValuesHelper(obj, key, list) {
    if (!obj) return list;
    if (obj instanceof Array) {
        for (var i in obj) {
            list = list.concat(findValuesHelper(obj[i], key, []));
        }
        return list;
    }
    if (obj[key]) list.push(obj[key]);

    if ((typeof obj == "object") && (obj !== null)) {
        var children = Object.keys(obj);
        if (children.length > 0) {
            for (i = 0; i < children.length; i++) {
                list = list.concat(findValuesHelper(obj[children[i]], key, []));
            }
        }
    }
    return list;
}

//if the value does not exist return empty string
//trim the white spaces from the value. trim
function cleanValue(val) {
	switch (typeof val) {
	case "string":
		return val.trim();
	case "boolean":
	case "number":
		return val;
	default:
		return "";
	}
}

function getNameWoIndexLength(fieldName) {
	var pos = fieldName.lastIndexOf('_');
	return  pos !== -1 && /^\d+$/.test(fieldName.substr(pos + 1)) ?
			pos : 
			fieldName.length;
}

function getNameWoIndex(fieldName) {
	return 	fieldName === undefined ? undefined :
			fieldName === null ? null :
			fieldName.substr(0, getNameWoIndexLength(fieldName));
}


function httpsValidation() {
	if (location.protocol !== 'https:' && location.hostname !== "localhost") {
		document.write('Must be opened via HTTPS!');
		if (typeof window.stop === "function") {
			window.stop();
		} else {
			document.execCommand("Stop"); // for IE
		} 
	}
}
