function gotDevices(deviceInfos) {
	if (deviceInfos.length === 0) {
		document.getElementById('nodevices_container').style.display = 'block';
		throw 'No video devices found';
	}
	for (var i = 0; i !== deviceInfos.length; ++i) {
		var deviceInfo = deviceInfos[i];
		if (deviceInfo.kind === 'videoinput') {
			var label = deviceInfo.label || 'camera ' + (devices.length + 1);
			var device = {text: label, value: deviceInfo.deviceId};
			
			if (label.toLowerCase().indexOf('back') !== -1) {
				devices.unshift(device);
			} else {
				devices.push(device);
			}
		} else {
			console.log('Some other kind of source/device: ', deviceInfo);
		}
	}
	document.getElementById('container').style.display = 'block';
				activeDevice = 0;
				start();
			}
  
			function gotStream(stream) {
				window.stream = stream; // make stream available to console
	video.srcObject = stream;
	return navigator.mediaDevices.enumerateDevices();	// refresh list in case labels have become available
}

function start() {
	if (window.stream) {
		window.stream.getTracks().forEach(function(track) {
			track.stop();
		});
	}
	var videoSource = devices[activeDevice].value;
	var constraints = {
		audio: undefined,
		video: {deviceId: videoSource ? {exact: videoSource} : undefined}
	};
	navigator.mediaDevices.getUserMedia(constraints).then(gotStream).catch(onCameraError);
}

function onCameraError(error) {
	console.log('navigator.getUserMedia error: ', error);
}

function drawToCanvas() {
	var context = canvas.getContext("2d");
	context.clearRect(0, 0, video.videoWidth, video.videoHeight);
	context.drawImage(video, 0, 0, video.videoWidth, video.videoHeight);
}

function startQrListener() {
	qrcode.setCanvasElement(canvas);

	setInterval(function () {
		try {
			drawToCanvas();
			var decodedValue = qrcode.decode();
			window.opener.Fields.set(cameraReturnElement, decodedValue);
			window.close();
		} catch (err){
			if (err !== "Couldn't find enough finder patterns") {
				console.log(err);
			}
		}
	}, 500);
}

function initCamera() {
	var isCameraSupported = location.protocol === 'https:' || location.hostname === 'localhost';
	if (!isCameraSupported) {
		document.getElementById('nocamera_container').style.display = 'block';
    	return;
    }
	if (navigator.mediaDevices === undefined) {
		document.getElementById('incompatible_container').style.display = 'block';
    	return;
	}
	
	var isQr = sessionStorage.getItem('APCAMERA_TYPE') === 'QR';
	document.getElementById(isQr ? 'cameraSaveAuto' : 'cameraSaveButton').style.display = 'block';
    	
	navigator.mediaDevices.enumerateDevices().then(gotDevices).catch(onCameraError);
    
    if (isQr) {
    	startQrListener();
    }
}

function cameraSave() {
	drawToCanvas();
	var fileInput = window.opener.document.getElementById(cameraReturnElement);
	fileInput.setAttribute("fileFromCamera", canvas.toDataURL());
	fileInput.setAttribute("uploaded", false);
	fileInput.value = "";
	window.opener.document.getElementById(cameraReturnElement + '_filename').innerHTML = '(From camera)';
	window.close();
}




var video = document.getElementById('video');
var canvas = document.getElementById('qr-canvas');
var cameraReturnElement = sessionStorage.getItem('APCAMERA_RETURN_ELEMENT');
var devices = [];
var activeDevice = 0;
document.getElementById('cameraSaveButton').onclick = function () {
	cameraSave();
}
document.getElementById('cameraSourceButton').onclick = function () {
	activeDevice = (activeDevice + 1) % devices.length; 
	start();
}

initCamera();